"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOverviewStatus = useOverviewStatus;
var _react = require("react");
var _reactRedux = require("react-redux");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _synthetics_refresh_context = require("../../../contexts/synthetics_refresh_context");
var _state = require("../../../state");
var _overview_status = require("../../../state/overview_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useOverviewStatus({
  scopeStatusByLocation
}) {
  const pageState = (0, _reactRedux.useSelector)(_state.selectOverviewPageState);
  const {
    status,
    error,
    loaded,
    loading,
    allConfigs
  } = (0, _reactRedux.useSelector)(_overview_status.selectOverviewStatus);
  const isInitialMount = (0, _react.useRef)(true);
  const {
    lastRefresh
  } = (0, _synthetics_refresh_context.useSyntheticsRefreshContext)();
  const dispatch = (0, _reactRedux.useDispatch)();

  // Periodically refresh
  (0, _react.useEffect)(() => {
    if (!isInitialMount.current) {
      dispatch(_overview_status.quietFetchOverviewStatusAction.get({
        pageState,
        scopeStatusByLocation
      }));
    }
    // specifically only want to run this on refreshInterval change
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [lastRefresh]);

  // On initial mount, load the page
  (0, _useDebounce.default)(() => {
    if (isInitialMount.current) {
      if (loaded) {
        dispatch(_overview_status.quietFetchOverviewStatusAction.get({
          pageState,
          scopeStatusByLocation
        }));
      } else {
        dispatch(_overview_status.fetchOverviewStatusAction.get({
          pageState,
          scopeStatusByLocation
        }));
      }
    }
  }, 100,
  // we don't use pageState or scopeStatus here, for pageState, useDebounce will handle it
  [dispatch]);
  (0, _useDebounce.default)(() => {
    // Don't load on initial mount, only meant to handle pageState changes
    if (isInitialMount.current || !loaded) {
      // setting false here to account for debounce timing
      isInitialMount.current = false;
      return;
    }
    dispatch(_overview_status.quietFetchOverviewStatusAction.get({
      pageState,
      scopeStatusByLocation
    }));
  }, 100, [pageState, scopeStatusByLocation]);
  return {
    status,
    error,
    loading,
    loaded,
    allConfigs: allConfigs !== null && allConfigs !== void 0 ? allConfigs : []
  };
}