"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDetailsPanelContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _monitor_details_panel = require("../../common/components/monitor_details_panel");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _runtime_types = require("../../../../../../common/runtime_types");
var _use_monitor_latest_ping = require("../hooks/use_monitor_latest_ping");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitor_details/monitor_summary/monitor_details_panel_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorDetailsPanelContainer = props => {
  var _latestPing$monitor;
  const {
    latestPing
  } = (0, _use_monitor_latest_ping.useMonitorLatestPing)();
  const {
    monitorId: configId
  } = (0, _reactRouterDom.useParams)();
  const {
    monitor,
    loading
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const isPingRelevant = (latestPing === null || latestPing === void 0 ? void 0 : latestPing.config_id) === (monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.CONFIG_ID]) || (latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$monitor = latestPing.monitor) === null || _latestPing$monitor === void 0 ? void 0 : _latestPing$monitor.id) === (monitor === null || monitor === void 0 ? void 0 : monitor[_runtime_types.ConfigKey.MONITOR_QUERY_ID]);
  if (!monitor || !isPingRelevant) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 6,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_monitor_details_panel.MonitorDetailsPanel, (0, _extends2.default)({
    latestPing: latestPing,
    monitor: monitor,
    loading: loading,
    configId: configId
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }));
};
exports.MonitorDetailsPanelContainer = MonitorDetailsPanelContainer;