"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeltaPercent = exports.ThresholdIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/thershold_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDeltaPercent = (current, previous) => {
  if (previous === 0 || previous === null || previous === undefined) {
    return 0;
  }
  return Number(((current - previous) / previous * 100).toFixed(0));
};
exports.getDeltaPercent = getDeltaPercent;
const ThresholdIndicator = ({
  description,
  helpText,
  loading,
  current,
  previous,
  previousFormatted,
  currentFormatted,
  asStat = false
}) => {
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 12
      }
    });
  }
  const delta = getDeltaPercent(current, previous);
  const getToolTipContent = () => {
    return _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.tooltip', {
      defaultMessage: 'Value is {deltaLabel} compared to previous steps in last 24 hours.',
      values: {
        deltaLabel: Math.abs(delta) === 0 ? _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.tooltip.noChange', {
          defaultMessage: 'same'
        }) : delta > 0 ? _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.increased', {
          defaultMessage: '{delta}% higher',
          values: {
            delta
          }
        }) : _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.decreased', {
          defaultMessage: '{delta}% lower',
          values: {
            delta: Math.abs(delta)
          }
        })
      }
    });
  };
  const getColor = () => {
    if (Math.abs(delta) < 5) {
      return 'default';
    }
    return delta > 5 ? 'danger' : 'success';
  };
  const hasDelta = Math.abs(delta) > 0;
  const content = previous === null ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minus",
    size: asStat ? 'l' : 'm',
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: getToolTipContent(),
    title: _i18n.i18n.translate('xpack.synthetics.stepDetails.palette.previous', {
      defaultMessage: 'Median(24h): {previous}',
      values: {
        previous: previousFormatted
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, hasDelta ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: delta > 0 ? 'sortUp' : 'sortDown',
    size: asStat ? 'l' : 'm',
    color: getColor(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minus",
    size: asStat ? 'l' : 'm',
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }));
  if (asStat) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
      titleSize: "s",
      titleColor: getColor(),
      description: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 11
        }
      }, description, " ", helpText && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: helpText,
        position: "right",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 40
        }
      })),
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, currentFormatted, /*#__PURE__*/_react.default.createElement("span", {
        style: {
          marginLeft: 5
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 13
        }
      }, content)),
      reverse: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: getColor(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, currentFormatted))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, content));
};
exports.ThresholdIndicator = ThresholdIndicator;