"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.READ = exports.NoPermissionsTooltip = exports.NEED_PRIVATE_LOCATIONS_PERMISSION = exports.NEED_PERMISSIONS_PRIVATE_LOCATIONS = exports.FleetPermissionsCallout = exports.CANNOT_PERFORM_ACTION_SYNTHETICS = exports.CANNOT_PERFORM_ACTION_PUBLIC_LOCATIONS = exports.ALL = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _disabled_callout = require("../../monitors_page/management/disabled_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/common/components/permissions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FleetPermissionsCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: NEED_PERMISSIONS_PRIVATE_LOCATIONS,
    color: "warning",
    iconType: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 7
    }
  }, NEED_PRIVATE_LOCATIONS_PERMISSION), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.privateLocations.needFleetPermission.description",
    defaultMessage: "Once there is an agent policy available, you'll be able to manage private locations and monitors with the regular Synthetics app privileges.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 9
    }
  })));
};

/**
 * If canEditSynthetics  is false, then wrap the children with a tooltip
 * so that a reason can be conveyed to the user explaining why the action is disabled.
 */
exports.FleetPermissionsCallout = FleetPermissionsCallout;
const NoPermissionsTooltip = ({
  canEditSynthetics = true,
  canUsePublicLocations = true,
  canManagePrivateLocations = true,
  content,
  children
}) => {
  const {
    isServiceAllowed
  } = (0, _hooks.useEnablement)();
  const disabledMessage = getRestrictionReasonLabel(canEditSynthetics, canUsePublicLocations, canManagePrivateLocations);
  if (!isServiceAllowed) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _disabled_callout.SERVICE_NOT_ALLOWED,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, children));
  }
  if (disabledMessage) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: disabledMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, children));
  }
  if (content) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: content,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }, children));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.NoPermissionsTooltip = NoPermissionsTooltip;
function getRestrictionReasonLabel(canEditSynthetics = true, canUsePublicLocations = true, canManagePrivateLocations = true) {
  const message = !canEditSynthetics ? CANNOT_PERFORM_ACTION_SYNTHETICS : undefined;
  if (message) {
    return message;
  }
  if (!canManagePrivateLocations) {
    return NEED_PERMISSIONS_PRIVATE_LOCATIONS;
  }
  return !canUsePublicLocations ? CANNOT_PERFORM_ACTION_PUBLIC_LOCATIONS : undefined;
}
const NEED_PERMISSIONS_PRIVATE_LOCATIONS = exports.NEED_PERMISSIONS_PRIVATE_LOCATIONS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.privateLocations.needPermissions', {
  defaultMessage: "You're missing some Kibana privileges to manage private locations"
});
const ALL = exports.ALL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.privileges.all', {
  defaultMessage: 'All'
});
const READ = exports.READ = _i18n.i18n.translate('xpack.synthetics.monitorManagement.privileges.read', {
  defaultMessage: 'Read'
});
const NEED_PRIVATE_LOCATIONS_PERMISSION = exports.NEED_PRIVATE_LOCATIONS_PERMISSION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.synthetics.monitorManagement.privateLocations.needFleetPermission",
  defaultMessage: "In order to create private locations, you need an agent policy. You are not authorized to create Fleet agent policies. It requires the {all} for Fleet and at least {read} for Integerations kibana priviliges.",
  values: {
    all: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 12
      }
    }, `"${ALL}"`),
    read: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 13
      }
    }, `"${READ}"`)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 115,
    columnNumber: 3
  }
});
const CANNOT_PERFORM_ACTION_SYNTHETICS = exports.CANNOT_PERFORM_ACTION_SYNTHETICS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.noSyntheticsPermissions', {
  defaultMessage: 'You do not have sufficient permissions to perform this action.'
});
const CANNOT_PERFORM_ACTION_PUBLIC_LOCATIONS = exports.CANNOT_PERFORM_ACTION_PUBLIC_LOCATIONS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.canUsePublicLocations', {
  defaultMessage: 'You do not have sufficient permissions to use Elastic managed locations.'
});