"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCertSearch = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _certs = require("../../state/certs");
var _get_certs_request_body = require("../../../../../common/requests/get_certs_request_body");
var _contexts = require("../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCertSearch = ({
  pageIndex,
  size = _get_certs_request_body.DEFAULT_SIZE,
  search,
  sortBy = _get_certs_request_body.DEFAULT_SORT,
  direction = _get_certs_request_body.DEFAULT_DIRECTION
}) => {
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.SyntheticsRefreshContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch(_certs.getCertsListAction.get({
      pageIndex,
      size,
      search,
      sortBy,
      direction
    }));
  }, [direction, dispatch, lastRefresh, pageIndex, search, size, sortBy]);
  const {
    data,
    isLoading
  } = (0, _reactRedux.useSelector)(_certs.selectCertsListState);
  return {
    ...(data !== null && data !== void 0 ? data : {
      certs: [],
      total: 0
    }),
    isLoading
  };
};
exports.useCertSearch = useCertSearch;