"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFilters = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_synthetics_suggestions = require("../hooks/use_fetch_synthetics_suggestions");
var _fields = require("./fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/alerts/common/field_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldFilters = ({
  ruleParams,
  setRuleParams,
  filters
}) => {
  const [search, setSearch] = (0, _react.useState)('');
  const [selectedField, setSelectedField] = (0, _react.useState)();
  const {
    suggestions = [],
    isLoading,
    allSuggestions
  } = (0, _use_fetch_synthetics_suggestions.useFetchSyntheticsSuggestions)({
    search,
    fieldName: selectedField,
    filters
  });
  const onFieldChange = (0, _react.useCallback)((key, value) => {
    setRuleParams(key, value);
  }, [setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_fields.MonitorField, {
    onChange: val => {
      onFieldChange('monitorIds', val);
    },
    value: ruleParams.monitorIds,
    setSearch: setSearch,
    suggestions: suggestions,
    allSuggestions: allSuggestions,
    isLoading: isLoading,
    setSelectedField: setSelectedField,
    selectedField: selectedField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_fields.MonitorTypeField, {
    onChange: val => {
      onFieldChange('monitorTypes', val);
    },
    value: ruleParams.monitorTypes,
    setSearch: setSearch,
    suggestions: suggestions,
    allSuggestions: allSuggestions,
    isLoading: isLoading,
    setSelectedField: setSelectedField,
    selectedField: selectedField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_fields.TagsField, {
    onChange: val => {
      onFieldChange('tags', val);
    },
    value: ruleParams.tags,
    setSearch: setSearch,
    suggestions: suggestions,
    allSuggestions: allSuggestions,
    isLoading: isLoading,
    setSelectedField: setSelectedField,
    selectedField: selectedField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_fields.ProjectsField, {
    onChange: val => {
      onFieldChange('projects', val);
    },
    value: ruleParams.projects,
    setSearch: setSearch,
    suggestions: suggestions,
    allSuggestions: allSuggestions,
    isLoading: isLoading,
    setSelectedField: setSelectedField,
    selectedField: selectedField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_fields.LocationsField, {
    onChange: val => {
      onFieldChange('locations', val);
    },
    value: ruleParams.locations,
    setSearch: setSearch,
    suggestions: suggestions,
    allSuggestions: allSuggestions,
    isLoading: isLoading,
    setSelectedField: setSelectedField,
    selectedField: selectedField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }));
};
exports.FieldFilters = FieldFilters;