"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatsOverviewEmbeddableFactory = exports.getOverviewPanelTitle = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _rxjs = require("rxjs");
var _constants = require("../constants");
var _stats_overview_component = require("./stats_overview_component");
var _monitors_open_configuration = require("../common/monitors_open_configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/embeddables/stats_overview/stats_overview_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getOverviewPanelTitle = () => _i18n.i18n.translate('xpack.synthetics.statusOverview.list.displayName', {
  defaultMessage: 'Synthetics Stats Overview'
});
exports.getOverviewPanelTitle = getOverviewPanelTitle;
const DEFAULT_FILTERS = {
  projects: [],
  tags: [],
  locations: [],
  monitorIds: [],
  monitorTypes: []
};
const getStatsOverviewEmbeddableFactory = getStartServices => {
  const factory = {
    type: _constants.SYNTHETICS_STATS_OVERVIEW_EMBEDDABLE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      parentApi,
      uuid
    }) => {
      var _dynamicActionsManage3;
      const [coreStart, pluginStart] = await getStartServices();
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const defaultTitle$ = new _rxjs.BehaviorSubject(getOverviewPanelTitle());
      const reload$ = new _rxjs.Subject();
      const filters$ = new _rxjs.BehaviorSubject(initialState.rawState.filters);
      const {
        embeddableEnhanced
      } = pluginStart;
      const dynamicActionsManager = embeddableEnhanced === null || embeddableEnhanced === void 0 ? void 0 : embeddableEnhanced.initializeEmbeddableDynamicActions(uuid, () => titleManager.api.title$.getValue(), initialState);
      const maybeStopDynamicActions = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.startDynamicActions();
      function serializeState() {
        var _dynamicActionsManage;
        const {
          rawState: dynamicActionsState,
          references: dynamicActionsReferences
        } = (_dynamicActionsManage = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.serializeState()) !== null && _dynamicActionsManage !== void 0 ? _dynamicActionsManage : {};
        return {
          rawState: {
            ...titleManager.getLatestState(),
            filters: filters$.getValue(),
            ...dynamicActionsState
          },
          references: dynamicActionsReferences !== null && dynamicActionsReferences !== void 0 ? dynamicActionsReferences : []
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        parentApi,
        uuid,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, filters$, ...(dynamicActionsManager ? [dynamicActionsManager.anyStateChange$] : [])).pipe((0, _rxjs.map)(() => undefined)),
        getComparators: () => {
          var _dynamicActionsManage2;
          return {
            ..._presentationPublishing.titleComparators,
            filters: 'referenceEquality',
            ...((_dynamicActionsManage2 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.comparators) !== null && _dynamicActionsManage2 !== void 0 ? _dynamicActionsManage2 : {
              enhancements: 'skip'
            })
          };
        },
        defaultState: {
          filters: DEFAULT_FILTERS
        },
        onReset: lastSaved => {
          var _lastSaved$rawState, _lastSaved$rawState$f;
          dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.reinitializeState((_lastSaved$rawState = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState) !== null && _lastSaved$rawState !== void 0 ? _lastSaved$rawState : {});
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          filters$.next((_lastSaved$rawState$f = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.filters) !== null && _lastSaved$rawState$f !== void 0 ? _lastSaved$rawState$f : DEFAULT_FILTERS);
        }
      });
      const api = finalizeApi({
        ...titleManager.api,
        ...((_dynamicActionsManage3 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.api) !== null && _dynamicActionsManage3 !== void 0 ? _dynamicActionsManage3 : {}),
        ...unsavedChangesApi,
        supportedTriggers: () => [],
        defaultTitle$,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.synthetics.editSloOverviewEmbeddableTitle.typeDisplayName', {
          defaultMessage: 'filters'
        }),
        isEditingEnabled: () => true,
        onEdit: async () => {
          try {
            const result = await (0, _monitors_open_configuration.openMonitorConfiguration)({
              coreStart,
              pluginStart,
              initialState: {
                filters: filters$.getValue() || DEFAULT_FILTERS
              },
              title: _i18n.i18n.translate('xpack.synthetics.editSloOverviewEmbeddableTitle.title', {
                defaultMessage: 'Create monitor stats'
              }),
              type: _constants.SYNTHETICS_STATS_OVERVIEW_EMBEDDABLE
            });
            filters$.next(result.filters);
          } catch (e) {
            return Promise.reject();
          }
        },
        serializeState
      });
      const fetchSubscription = (0, _presentationPublishing.fetch$)(api).pipe().subscribe(next => {
        reload$.next(next.isReload);
      });
      return {
        api,
        Component: () => {
          const [filters] = (0, _presentationPublishing.useBatchedPublishingSubjects)(filters$);
          (0, _react.useEffect)(() => {
            return () => {
              fetchSubscription.unsubscribe();
              maybeStopDynamicActions === null || maybeStopDynamicActions === void 0 ? void 0 : maybeStopDynamicActions.stopDynamicActions();
            };
          }, []);
          return /*#__PURE__*/_react.default.createElement("div", {
            style: {
              width: '100%'
            },
            "data-shared-item": "" // TODO: Remove data-shared-item and data-rendering-count as part of https://github.com/elastic/kibana/issues/179376
            ,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 175,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_stats_overview_component.StatsOverviewComponent, {
            reload$: reload$,
            filters: filters || DEFAULT_FILTERS,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 181,
              columnNumber: 15
            }
          }));
        }
      };
    }
  };
  return factory;
};
exports.getStatsOverviewEmbeddableFactory = getStatsOverviewEmbeddableFactory;