"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexPatternsForStream = getIndexPatternsForStream;
var _streams = require("../models/streams");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getIndexPatternsForStream(stream) {
  if (!stream) {
    return undefined;
  }
  if (_streams.Streams.ClassicStream.Definition.is(stream)) {
    return [stream.name];
  }
  const dataStreamOfDefinition = stream.name;
  return [dataStreamOfDefinition, `${dataStreamOfDefinition}.*`];
}