"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFeatureFlags = registerFeatureFlags;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerFeatureFlags(core, logger) {
  core.pricing.isFeatureAvailable(_common.STREAMS_TIERED_SIGNIFICANT_EVENT_FEATURE.id).then(isSignificantEventsAvailable => {
    if (isSignificantEventsAvailable) {
      core.uiSettings.register({
        [_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_SIGNIFICANT_EVENTS]: {
          category: ['observability'],
          name: _i18n.i18n.translate('xpack.streams.significantEventsSettingsName', {
            defaultMessage: 'Streams significant events'
          }),
          value: false,
          description: _i18n.i18n.translate('xpack.streams.significantEventsSettingsDescription', {
            defaultMessage: 'Enable streams significant events.'
          }),
          type: 'boolean',
          schema: _configSchema.schema.boolean(),
          requiresPageReload: true,
          solutionViews: ['classic', 'oblt'],
          technicalPreview: true
        }
      });
    }
  }).catch(error => {
    logger.error(`Failed to register significant events ui settings: ${error}`);
  });
  core.uiSettings.register({
    [_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_GROUP_STREAMS]: {
      category: ['observability'],
      name: _i18n.i18n.translate('xpack.streams.groupStreamsSettingsName', {
        defaultMessage: 'Group streams'
      }),
      value: false,
      description: _i18n.i18n.translate('xpack.streams.groupStreamsSettingsDescription', {
        defaultMessage: 'Enable Group streams.'
      }),
      type: 'boolean',
      schema: _configSchema.schema.boolean(),
      requiresPageReload: true,
      solutionViews: ['classic', 'oblt'],
      technicalPreview: true,
      readonly: true,
      readonlyMode: 'ui'
    }
  });
  core.uiSettings.register({
    [_managementSettingsIds.OBSERVABILITY_STREAMS_ENABLE_CONTENT_PACKS]: {
      category: ['observability'],
      name: _i18n.i18n.translate('xpack.streams.streamsContentPacksSettingsName', {
        defaultMessage: 'Streams content packs'
      }),
      value: false,
      description: _i18n.i18n.translate('xpack.streams.streamsContentPacksSettingsDescription', {
        defaultMessage: 'Enable Streams content packs.'
      }),
      type: 'boolean',
      schema: _configSchema.schema.boolean(),
      requiresPageReload: true,
      solutionViews: ['classic', 'oblt'],
      technicalPreview: true
    }
  });
}