"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsTelemetryClient = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StreamsTelemetryClient {
  constructor(analytics) {
    this.analytics = analytics;
  }
  trackAssetCounts(params) {
    this.analytics.reportEvent(_constants.STREAMS_ASSET_COUNT_EVENT_TYPE, params);
  }
  trackAssetClick(params) {
    this.analytics.reportEvent(_constants.STREAMS_ASSET_CLICK_EVENT_TYPE, params);
  }
  startTrackingAIGrokSuggestionLatency(params) {
    const start = Date.now();
    return (count, rates) => {
      this.analytics.reportEvent(_constants.STREAMS_AI_GROK_SUGGESTION_LATENCY_EVENT_TYPE, {
        ...params,
        duration_ms: Date.now() - start,
        suggestion_count: count,
        match_rate: rates
      });
    };
  }
  trackAIGrokSuggestionAccepted(params) {
    this.analytics.reportEvent(_constants.STREAMS_AI_GROK_SUGGESTION_ACCEPTED_EVENT_TYPE, params);
  }
  trackWiredStreamsStatusChanged(params) {
    this.analytics.reportEvent(_constants.STREAMS_WIRED_STREAMS_STATUS_CHANGED_EVENT_TYPE, params);
  }
  trackProcessingSaved(params) {
    this.analytics.reportEvent(_constants.STREAMS_PROCESSING_SAVED_EVENT_TYPE, params);
  }
  trackRetentionChanged(lifecycle, streamType) {
    this.analytics.reportEvent(_constants.STREAMS_RETENTION_CHANGED_EVENT_TYPE, {
      lifecycle_type: this.getLifecycleType(lifecycle),
      lifecycle_value: this.getLifecycleValue(lifecycle),
      stream_type: streamType
    });
  }
  trackChildStreamCreated(props) {
    this.analytics.reportEvent(_constants.STREAMS_CHILD_STREAM_CREATED_EVENT_TYPE, props);
  }
  trackSchemaUpdated(props) {
    this.analytics.reportEvent(_constants.STREAMS_SCHEMA_UPDATED_EVENT_TYPE, props);
  }
  trackSignificantEventsSuggestionsGenerate(params) {
    this.analytics.reportEvent(_constants.STREAMS_SIGNIFICANT_EVENTS_SUGGESTIONS_GENERATED_EVENT_TYPE, params);
  }
  trackSignificantEventsCreated(params) {
    this.analytics.reportEvent(_constants.STREAMS_SIGNIFICANT_EVENTS_CREATED_EVENT_TYPE, params);
  }
  getLifecycleType(lifecycle) {
    if ('dsl' in lifecycle) {
      return 'dsl';
    }
    if ('ilm' in lifecycle) {
      return 'ilm';
    }
    return 'inherit';
  }
  getLifecycleValue(lifecycle) {
    if ('dsl' in lifecycle) {
      return lifecycle.dsl.data_retention;
    }
    if ('ilm' in lifecycle) {
      return lifecycle.ilm.policy;
    }
    return undefined;
  }
}
exports.StreamsTelemetryClient = StreamsTelemetryClient;