"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIConnectorSelector = AIConnectorSelector;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/add_significant_event_flyout/generated_flow_form/ai_connector_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AIConnectorSelector({
  genAiConnectors,
  disabled
}) {
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const splitButtonPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'splitButtonPopover'
  });
  if (!genAiConnectors.connectors || genAiConnectors.connectors.length <= 1) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: splitButtonPopoverId,
    isOpen: isPopoverOpen,
    closePopover: () => closePopover(),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      disabled: disabled,
      "data-test-subj": "streamsAppSignificantEventsAiPickConnectorButton",
      onClick: togglePopover,
      display: "base",
      size: "s",
      iconType: "boxesVertical",
      "aria-label": _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.aiFlow.pickConnectorLabel', {
        defaultMessage: 'Select AI connector'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 11
      }
    }),
    panelPaddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: genAiConnectors.connectors.map(connector => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: connector.id,
      icon: connector.id === genAiConnectors.selectedConnector ? 'check' : 'empty',
      onClick: () => {
        genAiConnectors.selectConnector(connector.id);
        closePopover();
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    }, connector.name)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })));
}