"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChildStreamList = ChildStreamList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _streamsSchema = require("@kbn/streams-schema");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _asset_image = require("../asset_image");
var _streams_list = require("../streams_list");
var _use_wired_streams = require("../../hooks/use_wired_streams");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_overview/child_stream_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ChildStreamList({
  definition
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    wiredStreams
  } = (0, _use_wired_streams.useWiredStreams)();
  const childrenStreams = (0, _react.useMemo)(() => {
    if (!definition) {
      return [];
    }
    return wiredStreams === null || wiredStreams === void 0 ? void 0 : wiredStreams.filter(d => (0, _streamsSchema.isDescendantOf)(definition.stream.name, d.name));
  }, [definition, wiredStreams]);
  if (definition && (childrenStreams === null || childrenStreams === void 0 ? void 0 : childrenStreams.length) === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: (0, _css.css)`
              max-width: 350px;
            `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "welcome",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      textAlign: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.entityDetailOverview.noChildStreams', {
      defaultMessage: 'Create streams for your logs'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.entityDetailOverview.noChildStreams', {
      defaultMessage: 'Create sub streams to split out data with different retention policies, schemas, and more.'
    })), definition.privileges.manage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "streamsAppChildStreamListCreateChildStreamButton",
      iconType: "plusInCircle",
      href: router.link('/{key}/management/{tab}', {
        path: {
          key: definition.stream.name,
          tab: 'partitioning'
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.streams.entityDetailOverview.createChildStream', {
      defaultMessage: 'Create child stream'
    })))))));
  }
  return /*#__PURE__*/_react.default.createElement(_streams_list.StreamsList, {
    streams: childrenStreams,
    showControls: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 10
    }
  });
}