"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamNameFormRow = StreamNameFormRow;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/stream_name_form_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_NAME_LENGTH = 200;
function StreamNameFormRow({
  value,
  onChange = () => {},
  disabled = false,
  autoFocus = false
}) {
  const helpText = value.length >= MAX_NAME_LENGTH && !disabled ? _i18n.i18n.translate('xpack.streams.streamDetailRouting.nameHelpText', {
    defaultMessage: `Stream name cannot be longer than {maxLength} characters.`,
    values: {
      maxLength: MAX_NAME_LENGTH
    }
  }) : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.streams.streamDetailRouting.name', {
      defaultMessage: 'Stream name'
    }),
    helpText: helpText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "streamsAppRoutingStreamEntryNameField",
    value: value,
    fullWidth: true,
    compressed: true,
    disabled: disabled,
    autoFocus: autoFocus,
    onChange: e => onChange(e.target.value),
    maxLength: 200,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
}