"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WiredStreamDetailManagement = WiredStreamDetailManagement;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_streams_app_params = require("../../../hooks/use_streams_app_params");
var _redirect_to = require("../../redirect_to");
var _stream_detail_routing = require("../stream_detail_routing");
var _stream_detail_schema_editor = require("../stream_detail_schema_editor");
var _stream_detail_lifecycle = require("../stream_detail_lifecycle");
var _wrapper = require("./wrapper");
var _use_streams_detail_management_tabs = require("./use_streams_detail_management_tabs");
var _wired_advanced_view = require("./wired_advanced_view");
var _stream_data_quality = require("../../stream_data_quality");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/wired.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const wiredStreamManagementSubTabs = ['partitioning', 'processing', 'schema', 'retention', 'advanced', 'significantEvents', 'dataQuality', 'references'];
const tabRedirects = {
  schemaEditor: {
    newTab: 'schema'
  },
  lifecycle: {
    newTab: 'retention'
  },
  route: {
    newTab: 'partitioning'
  },
  enrich: {
    newTab: 'processing'
  }
};
function isValidManagementSubTab(value) {
  return wiredStreamManagementSubTabs.includes(value);
}
function WiredStreamDetailManagement({
  definition,
  refreshDefinition
}) {
  const {
    path: {
      key,
      tab
    }
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}/management/{tab}');
  const {
    processing,
    isLoading,
    ...otherTabs
  } = (0, _use_streams_detail_management_tabs.useStreamsDetailManagementTabs)({
    definition,
    refreshDefinition
  });
  const tabs = {
    retention: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_lifecycle.StreamDetailLifecycle, {
        definition: definition,
        refreshDefinition: refreshDefinition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 9
        }
      }),
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.streams.managementTab.lifecycle.tooltip', {
          defaultMessage: 'Control how long data stays in this stream. Set a custom duration or apply a shared policy.'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.streamDetailView.lifecycleTab', {
        defaultMessage: 'Retention'
      })))
    },
    partitioning: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_routing.StreamDetailRouting, {
        definition: definition,
        refreshDefinition: refreshDefinition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 9
        }
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.routingTab', {
        defaultMessage: 'Partitioning'
      })
    },
    processing,
    schema: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_schema_editor.StreamDetailSchemaEditor, {
        definition: definition,
        refreshDefinition: refreshDefinition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 9
        }
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.schemaEditorTab', {
        defaultMessage: 'Schema'
      })
    },
    dataQuality: {
      content: /*#__PURE__*/_react.default.createElement(_stream_data_quality.StreamDetailDataQuality, {
        definition: definition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 16
        }
      }),
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.streams.managementTab.dataQuality.wired.tooltip', {
          defaultMessage: 'View details about this stream’s data quality'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "dataQualityTab",
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.streamDetailView.qualityTab', {
        defaultMessage: 'Data quality'
      })))
    },
    ...otherTabs,
    ...(definition.privileges.manage ? {
      advanced: {
        content: /*#__PURE__*/_react.default.createElement(_wired_advanced_view.WiredAdvancedView, {
          definition: definition,
          refreshDefinition: refreshDefinition,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 15
          }
        }),
        label: _i18n.i18n.translate('xpack.streams.streamDetailView.advancedTab', {
          defaultMessage: 'Advanced'
        })
      }
    } : {})
  };
  const redirectConfig = tabRedirects[tab];
  if (redirectConfig) {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      path: "/{key}/management/{tab}",
      params: {
        path: {
          key,
          tab: redirectConfig.newTab
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 7
      }
    });
  }
  if (isValidManagementSubTab(tab)) {
    return /*#__PURE__*/_react.default.createElement(_wrapper.Wrapper, {
      tabs: tabs,
      streamId: key,
      tab: tab,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 12
      }
    });
  }
  if (isLoading) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
    path: "/{key}/management/{tab}",
    params: {
      path: {
        key,
        tab: 'partitioning'
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  });
}