"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Settings = Settings;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _streamsSchema = require("@kbn/streams-schema");
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _use_kibana = require("../../../../hooks/use_kibana");
var _errors = require("../../../../util/errors");
var _use_streams_app_router = require("../../../../hooks/use_streams_app_router");
var _use_stream_detail = require("../../../../hooks/use_stream_detail");
var _row = require("./row");
var _helpers = require("../../stream_detail_lifecycle/helpers/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/advanced_view/settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function toStringValues(settings, effectiveSettings) {
  return Object.entries(effectiveSettings).reduce((acc, [key, setting]) => {
    acc[key] = {
      ...setting,
      value: String(setting.value),
      invalid: false,
      override: !!settings[key]
    };
    return acc;
  }, {});
}
function Settings({
  definition,
  refreshDefinition,
  children
}) {
  var _settings$indexNumbe, _settings$indexNumbe2, _settings$indexRefre;
  const {
    loading: isLoadingDefinition
  } = (0, _use_stream_detail.useStreamDetail)();
  const {
    isServerless,
    core: {
      notifications
    },
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const originalSettings = (0, _react.useMemo)(() => toStringValues(definition.stream.ingest.settings, definition.effective_settings), [definition]);
  const isClassicStream = (0, _react.useMemo)(() => _streamsSchema.Streams.ClassicStream.GetResponse.is(definition), [definition]);
  const [settings, setSettings] = (0, _react.useState)({});
  const hasChanges = (0, _react.useMemo)(() => !(0, _lodash.isEqual)(originalSettings, settings), [originalSettings, settings]);
  const updateSetting = (0, _react.useCallback)((name, value, invalid) => {
    if (value.length === 0) {
      setSettings(prev => (0, _lodash.omit)(prev, name));
    } else {
      const setting = {
        value,
        invalid,
        override: true
      };
      if (!isClassicStream) {
        setting.from = definition.stream.name;
      }
      setSettings(prev => ({
        ...prev,
        [name]: setting
      }));
    }
  }, [isClassicStream, definition.stream.name, setSettings]);
  const abortController = (0, _reactHooks.useAbortController)();
  const [isUpdating, setIsUpdating] = (0, _react.useState)(false);
  const onReset = (0, _react.useCallback)(name => {
    if (isClassicStream) {
      setSettings(prev => (0, _lodash.omit)(prev, name));
      return;
    }
    const original = originalSettings[name];
    if (!original || original.from === definition.stream.name) {
      setSettings(prev => (0, _lodash.omit)(prev, name));
    } else {
      setSettings(prev => ({
        ...prev,
        [name]: original
      }));
    }
  }, [originalSettings, isClassicStream, definition.stream.name]);
  const updateSettings = (0, _react.useCallback)(async () => {
    setIsUpdating(true);
    try {
      await streamsRepositoryClient.fetch('PUT /api/streams/{name}/_ingest 2023-10-31', {
        params: {
          path: {
            name: definition.stream.name
          },
          body: {
            ingest: {
              ...definition.stream.ingest,
              settings: prepareSettings(settings)
            }
          }
        },
        signal: abortController.signal
      });
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.streams.settings.successfullyUpdatedSettings', {
          defaultMessage: 'Settings updated'
        })
      });
      refreshDefinition();
    } catch (error) {
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.streams.settings.failedToUpdateSettings', {
          defaultMessage: 'Failed to update settings'
        }),
        toastMessage: (0, _errors.getFormattedError)(error).message
      });
    } finally {
      setIsUpdating(false);
    }
  }, [definition, settings, abortController.signal, streamsRepositoryClient, notifications.toasts, refreshDefinition]);
  (0, _react.useEffect)(() => {
    if (!definition) return;
    setSettings(toStringValues(definition.stream.ingest.settings, definition.effective_settings));
  }, [definition, setSettings]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, isServerless ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SettingRow, {
    label: _i18n.i18n.translate('xpack.streams.settings.indexConfiguration.shardsLabel', {
      defaultMessage: 'Shards'
    }),
    inputLabel: _i18n.i18n.translate('xpack.streams.settings.indexConfiguration.shardsInputLabel', {
      defaultMessage: 'Number of shards'
    }),
    description: _i18n.i18n.translate('xpack.streams.settings.indexConfiguration.shardsDescription', {
      defaultMessage: 'Control how the index is split across nodes. More shards can improve parallelism but may increase overhead.'
    }),
    setting: settings['index.number_of_shards'],
    isInvalid: (_settings$indexNumbe = settings['index.number_of_shards']) === null || _settings$indexNumbe === void 0 ? void 0 : _settings$indexNumbe.invalid,
    onChange: value => updateSetting('index.number_of_shards', value, !!value && (isInvalidInteger(value) || Number(value) === 0)),
    onReset: () => onReset('index.number_of_shards'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(SettingRow, {
    label: _i18n.i18n.translate('xpack.streams.settings.indexConfiguration.replicasLabel', {
      defaultMessage: 'Replicas'
    }),
    inputLabel: _i18n.i18n.translate('xpack.streams.settings.indexConfiguration.replicasInputLabel', {
      defaultMessage: 'Number of replicas'
    }),
    description: _i18n.i18n.translate('xpack.streams.settings.indexConfiguration.replicasDescription', {
      defaultMessage: 'Define how many copies of the data exist. More replicas improve resilience and read performance but increase storage usage.'
    }),
    setting: settings['index.number_of_replicas'],
    isInvalid: (_settings$indexNumbe2 = settings['index.number_of_replicas']) === null || _settings$indexNumbe2 === void 0 ? void 0 : _settings$indexNumbe2.invalid,
    onChange: value => updateSetting('index.number_of_replicas', value, !!value && isInvalidInteger(value)),
    onReset: () => onReset('index.number_of_replicas'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(SettingRow, {
    label: _i18n.i18n.translate('xpack.streams.settings.indexConfiguration.refreshIntervalLabel', {
      defaultMessage: 'Refresh Interval'
    }),
    inputLabel: _i18n.i18n.translate('xpack.streams.settings.indexConfiguration.refreshIntervalInputLabel', {
      defaultMessage: 'Refresh interval'
    }),
    description: _i18n.i18n.translate('xpack.streams.settings.indexConfiguration.refreshIntervalDescription', {
      defaultMessage: 'Control how frequently new data becomes visible for search. A longer interval reduces resource usage; a short one makes data searchable sooner.'
    }),
    setting: settings['index.refresh_interval'],
    isInvalid: (_settings$indexRefre = settings['index.refresh_interval']) === null || _settings$indexRefre === void 0 ? void 0 : _settings$indexRefre.invalid,
    valueDescription: "Accepts time values like 5s, 30s, 1m. Set to -1 to disable.",
    onChange: value => updateSetting('index.refresh_interval', value, !!value && !(0, _helpers.parseDuration)(value) && Number(value) !== -1),
    onReset: () => onReset('index.refresh_interval'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isDisabled: !hasChanges || isUpdating,
    onClick: () => setSettings(toStringValues(definition.stream.ingest.settings, definition.effective_settings)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.settings.cancelChangesButton', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isUpdating || isLoadingDefinition,
    isDisabled: !hasChanges || isLoadingDefinition || Object.values(settings).some(({
      invalid
    }) => invalid),
    color: "primary",
    fill: true,
    onClick: updateSettings,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.settings.saveChangesButton', {
    defaultMessage: 'Save changes'
  })))));
}
const prepareSettings = input => {
  var _input$indexNumber_o, _input$indexNumber_o2, _input$indexRefresh_;
  const settings = {};
  if (((_input$indexNumber_o = input['index.number_of_shards']) === null || _input$indexNumber_o === void 0 ? void 0 : _input$indexNumber_o.override) === true) {
    settings['index.number_of_shards'] = {
      value: Number(input['index.number_of_shards'].value)
    };
  }
  if (((_input$indexNumber_o2 = input['index.number_of_replicas']) === null || _input$indexNumber_o2 === void 0 ? void 0 : _input$indexNumber_o2.override) === true) {
    settings['index.number_of_replicas'] = {
      value: Number(input['index.number_of_replicas'].value)
    };
  }
  if (((_input$indexRefresh_ = input['index.refresh_interval']) === null || _input$indexRefresh_ === void 0 ? void 0 : _input$indexRefresh_.override) === true) {
    const value = input['index.refresh_interval'].value;
    if (Number(value) === -1) {
      settings['index.refresh_interval'] = {
        value: -1
      };
    } else {
      settings['index.refresh_interval'] = {
        value: input['index.refresh_interval'].value
      };
    }
  }
  return settings;
};
function SettingRow({
  label,
  inputLabel,
  description,
  setting,
  valueDescription,
  isInvalid,
  onChange,
  onReset
}) {
  var _setting$value;
  return /*#__PURE__*/_react.default.createElement(_row.Row, {
    left: /*#__PURE__*/_react.default.createElement(_row.RowMetadata, {
      label: label,
      description: description,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 13
      }
    }),
    right: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 349,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 350,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: inputLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 351,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: label,
      isInvalid: isInvalid,
      value: (_setting$value = setting === null || setting === void 0 ? void 0 : setting.value) !== null && _setting$value !== void 0 ? _setting$value : '',
      onChange: e => onChange(e.target.value),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 361,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 363,
        columnNumber: 15
      }
    }, valueDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 368,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 369,
        columnNumber: 15
      }
    }, setting !== null && setting !== void 0 && setting.override ? /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.override', {
      defaultMessage: 'Override.'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onReset(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 375,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.resetToDefault', {
      defaultMessage: 'Reset to default'
    }))) : setting !== null && setting !== void 0 && setting.from ? /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 382,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.inheritedFrom', {
      defaultMessage: 'Inherited from'
    }), ' ', /*#__PURE__*/_react.default.createElement(LinkToStream, {
      name: setting.from,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 386,
        columnNumber: 21
      }
    })) : null)))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 5
    }
  });
}
const isInvalidInteger = value => {
  const num = Number(value);
  return isNaN(num) || num < 0 || num % 1 > 0;
};
function LinkToStream({
  name
}) {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "streamsAppLinkToStreamLink",
    target: "_blank",
    href: router.link('/{key}/{tab}', {
      path: {
        key: name,
        tab: 'overview'
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 5
    }
  }, "[", name, "]");
}