"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IlmField = IlmField;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _eui = require("@elastic/eui");
var _errors = require("../../../../../util/errors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/general_data/modal/ilm.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function IlmField({
  getIlmPolicies,
  initialValue,
  setLifecycle,
  setSaveButtonDisabled,
  readOnly
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [selectedPolicy, setSelectedPolicy] = (0, _react.useState)((0, _streamsSchema.isIlmLifecycle)(initialValue) ? initialValue.ilm.policy : undefined);
  const [policies, setPolicies] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [errorMessage, setErrorMessage] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    setSelectedPolicy((0, _streamsSchema.isIlmLifecycle)(initialValue) ? initialValue.ilm.policy : undefined);
  }, [initialValue]);
  const isBorealis = euiTheme.themeName === 'EUI_THEME_BOREALIS';
  const phaseToIndicatorColors = {
    hot: isBorealis ? euiTheme.colors.vis.euiColorVis6 : euiTheme.colors.vis.euiColorVis9,
    warm: isBorealis ? euiTheme.colors.vis.euiColorVis9 : euiTheme.colors.vis.euiColorVis5,
    cold: isBorealis ? euiTheme.colors.vis.euiColorVis2 : euiTheme.colors.vis.euiColorVis1,
    frozen: euiTheme.colors.vis.euiColorVis4
  };
  (0, _react.useEffect)(() => {
    const phasesDescription = phases => {
      const desc = [];
      let previosStartAge;
      if (phases.delete) {
        previosStartAge = phases.delete.min_age;
      }
      if (phases.frozen) {
        var _phases$frozen$min_ag;
        desc.push({
          description: _i18n.i18n.translate('xpack.streams.phases.frozen', {
            defaultMessage: 'Frozen {previosStartAge, select, undefined {indefinitely} other {for {previosStartAge}}}',
            values: {
              previosStartAge
            }
          }),
          color: phaseToIndicatorColors.frozen
        });
        previosStartAge = (_phases$frozen$min_ag = phases.frozen.min_age) !== null && _phases$frozen$min_ag !== void 0 ? _phases$frozen$min_ag : previosStartAge;
      }
      if (phases.cold) {
        var _phases$cold$min_age;
        desc.push({
          description: _i18n.i18n.translate('xpack.streams.phases.cold', {
            defaultMessage: 'Cold {previosStartAge, select, undefined {indefinitely} other {for {previosStartAge}}}',
            values: {
              previosStartAge
            }
          }),
          color: phaseToIndicatorColors.cold
        });
        previosStartAge = (_phases$cold$min_age = phases.cold.min_age) !== null && _phases$cold$min_age !== void 0 ? _phases$cold$min_age : previosStartAge;
      }
      if (phases.warm) {
        var _phases$warm$min_age;
        desc.push({
          description: _i18n.i18n.translate('xpack.streams.phases.warm', {
            defaultMessage: 'Warm {previosStartAge, select, undefined {indefinitely} other {for {previosStartAge}}}',
            values: {
              previosStartAge
            }
          }),
          color: phaseToIndicatorColors.warm
        });
        previosStartAge = (_phases$warm$min_age = phases.warm.min_age) !== null && _phases$warm$min_age !== void 0 ? _phases$warm$min_age : previosStartAge;
      }
      if (phases.hot) {
        var _phases$hot$min_age;
        desc.push({
          description: _i18n.i18n.translate('xpack.streams.phases.hot', {
            defaultMessage: 'Hot {previosStartAge, select, undefined {indefinitely} other {for {previosStartAge}}}',
            values: {
              previosStartAge
            }
          }),
          color: phaseToIndicatorColors.hot
        });
        previosStartAge = (_phases$hot$min_age = phases.hot.min_age) !== null && _phases$hot$min_age !== void 0 ? _phases$hot$min_age : previosStartAge;
      }
      return desc.reverse();
    };
    setIsLoading(true);
    getIlmPolicies().then(ilmPolicies => {
      const policyOptions = ilmPolicies.map(({
        name,
        policy
      }) => ({
        label: `${name}`,
        searchableLabel: name,
        checked: selectedPolicy === name ? 'on' : undefined,
        data: {
          phases: phasesDescription(policy.phases)
        }
      }));
      setPolicies(policyOptions);
    }).catch(error => {
      setErrorMessage((0, _errors.getFormattedError)(error).message);
    }).finally(() => setIsLoading(false));

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const initialPolicyOption = (0, _streamsSchema.isIlmLifecycle)(initialValue) ? policies.find(option => option.label === initialValue.ilm.policy) : undefined;
  if (readOnly) {
    var _initialPolicyOption$, _initialPolicyOption$2;
    return initialPolicyOption && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      hasShadow: false,
      paddingSize: "s",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, initialPolicyOption.label, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      className: "eui-displayBlock",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      direction: "row",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 15
      }
    }, (_initialPolicyOption$ = initialPolicyOption.data) === null || _initialPolicyOption$ === void 0 ? void 0 : (_initialPolicyOption$2 = _initialPolicyOption$.phases) === null || _initialPolicyOption$2 === void 0 ? void 0 : _initialPolicyOption$2.map((phase, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: idx,
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      textSize: "xs",
      color: phase.color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 21
      }
    }, phase.description)))))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    singleSelection: true,
    isLoading: isLoading,
    options: policies,
    errorMessage: errorMessage,
    onChange: options => {
      var _options$find;
      const newSelectedPolicy = (_options$find = options.find(option => option.checked === 'on')) === null || _options$find === void 0 ? void 0 : _options$find.label;
      setSelectedPolicy(newSelectedPolicy);
      setPolicies(options);
      if (newSelectedPolicy) {
        setSaveButtonDisabled(false);
        setLifecycle({
          ilm: {
            policy: newSelectedPolicy
          }
        });
      } else {
        setSaveButtonDisabled(true);
      }
    },
    listProps: {
      rowHeight: 45
    },
    renderOption: (option, searchValue) => {
      var _option$phases;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
        search: searchValue,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 13
        }
      }, option.label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        className: "eui-displayBlock",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        direction: "row",
        responsive: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 15
        }
      }, (_option$phases = option.phases) === null || _option$phases === void 0 ? void 0 : _option$phases.map((phase, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: idx,
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        textSize: "xs",
        color: phase.color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 21
        }
      }, phase.description))))));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list)));
}