"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IlmLink = IlmLink;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _indexLifecycleManagementCommonShared = require("@kbn/index-lifecycle-management-common-shared");
var _use_kibana = require("../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/general_data/ilm_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function IlmLink({
  lifecycle
}) {
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const ilmLocator = share.url.locators.get(_indexLifecycleManagementCommonShared.ILM_LOCATOR_ID);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    "data-test-subj": "streamsAppLifecycleBadgeIlmPolicyNameLink",
    href: ilmLocator === null || ilmLocator === void 0 ? void 0 : ilmLocator.getRedirectUrl({
      page: 'policy_edit',
      policyName: lifecycle.ilm.policy
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, lifecycle.ilm.policy);
}