"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetentionCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _use_failure_store_redirect_link = require("../../hooks/use_failure_store_redirect_link");
var _base_metric_card = require("../../common/base_metric_card");
var _format_size_units = require("../../helpers/format_size_units");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/failure_store/cards/retention_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RetentionCard = ({
  openModal,
  definition,
  failureStore
}) => {
  const {
    href
  } = (0, _use_failure_store_redirect_link.useFailureStoreRedirectLink)({
    definition
  });
  const {
    privileges: {
      manage_failure_store: manageFailureStorePrivilege
    }
  } = definition;
  if (!failureStore || !failureStore.retentionPeriod) {
    return null;
  }
  const {
    retentionPeriod
  } = failureStore;
  const title = _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failureRetentionCard.title', {
    defaultMessage: 'Failure retention'
  });
  const retentionTypeApplied = retentionPeriod.custom ? _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failureRetentionCard.custom', {
    defaultMessage: 'Custom retention period'
  }) : _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failureRetentionCard.default', {
    defaultMessage: 'Default retention period'
  });
  const failureRetentionPeriod = retentionPeriod.custom ? (0, _format_size_units.getTimeSizeAndUnitLabel)(retentionPeriod.custom) : (0, _format_size_units.getTimeSizeAndUnitLabel)(retentionPeriod.default);
  const viewInDiscover = _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failureRetentionCard.discoverButton', {
    defaultMessage: 'View in discover'
  });
  const editFailureStore = _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failureRetentionCard.editButton', {
    defaultMessage: 'Edit failure store'
  });
  const getActions = () => {
    const actions = [];
    if (manageFailureStorePrivilege && !_streamsSchema.Streams.WiredStream.GetResponse.is(definition)) {
      actions.push({
        iconType: 'pencil',
        ariaLabel: editFailureStore,
        tooltip: editFailureStore,
        onClick: () => openModal(true),
        'data-test-subj': 'streamFailureStoreEditRetention'
      });
    }
    actions.push({
      iconType: 'discoverApp',
      ariaLabel: viewInDiscover,
      tooltip: viewInDiscover,
      href,
      'data-test-subj': 'streamFailureStoreViewInDiscover'
    });
    return actions;
  };
  const metric = [{
    data: failureRetentionPeriod,
    subtitle: retentionTypeApplied,
    'data-test-subj': 'failureStoreRetention'
  }];
  return /*#__PURE__*/_react.default.createElement(_base_metric_card.BaseMetricCard, {
    title: title,
    actions: getActions(),
    metrics: metric,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 10
    }
  });
};
exports.RetentionCard = RetentionCard;