"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverrideField = exports.MediaTypeField = exports.IgnoreEmptyValueField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _toggle_field = require("../toggle_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/set/set_optional_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OverrideField = () => {
  return /*#__PURE__*/_react.default.createElement(_toggle_field.ToggleField, {
    name: 'override',
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setOverrideLabel', {
      defaultMessage: 'Override'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setOverrideHelpText",
      defaultMessage: "If true, the processor will update fields with pre-existing non-null field values. If false, non-null fields are not updated.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  });
};
exports.OverrideField = OverrideField;
const IgnoreEmptyValueField = () => {
  return /*#__PURE__*/_react.default.createElement(_toggle_field.ToggleField, {
    name: 'ignore_empty_value',
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setIgnoreEmptyValueLabel', {
      defaultMessage: 'Ignore empty value'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setIgnoreEmptyValueHelpText",
      defaultMessage: "If true and {value} is a template snippet that evaluates to null or an empty string, the processor quietly exits without modifying the document.",
      values: {
        value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 46,
            columnNumber: 28
          }
        }, "value")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
};
exports.IgnoreEmptyValueField = IgnoreEmptyValueField;
const MediaTypeField = () => {
  const {
    register
  } = (0, _reactHookForm.useFormContext)();
  const {
    ref,
    ...inputProps
  } = register('media_type');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setMediaTypeLabel', {
      defaultMessage: 'Media type'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setMediaTypeHelpText",
      defaultMessage: "The media type for encoding value. Applies only when {value} is a template snippet. Must be one of application/json, text/plain, or application/x-www-form-urlencoded.",
      values: {
        value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 28
          }
        }, "value")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, inputProps, {
    inputRef: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  })));
};
exports.MediaTypeField = MediaTypeField;