"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArrayField = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/config_driven/components/array_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ArrayField = ({
  fieldConfiguration
}) => {
  const {
    field: fieldName,
    label,
    helpText,
    required
  } = fieldConfiguration;
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: fieldName,
    rules: {
      ...(required ? {
        required: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.arrayFieldRequiredError', {
          defaultMessage: 'A value for {fieldName} is required.',
          values: {
            fieldName
          }
        })
      } : {})
    }
  });
  const {
    invalid,
    error
  } = fieldState;
  const handleChange = options => {
    field.onChange(options.map(option => option.label));
  };
  const handleCreate = value => {
    const newValue = [...field.value, value];
    field.onChange(newValue);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    helpText: helpText,
    fullWidth: true,
    isInvalid: invalid,
    error: error === null || error === void 0 ? void 0 : error.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: invalid,
    fullWidth: true,
    noSuggestions: true,
    inputRef: field.ref,
    placeholder: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.arrayFieldPlaceholder', {
      defaultMessage: 'Type and then hit "ENTER"'
    }),
    selectedOptions: field.value.map(v => ({
      label: v
    })),
    onCreateOption: handleCreate,
    onChange: handleChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
};
exports.ArrayField = ArrayField;