"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepsProcessingSummary = void 0;
var _react = require("react");
var _streamlang = require("@kbn/streamlang");
var _stream_enrichment_state_machine = require("./stream_enrichment_state_machine");
var _selectors = require("./stream_enrichment_state_machine/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStepsProcessingSummary = () => {
  const stepsContext = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => {
    return new Map(state.context.stepRefs.map(stepRef => [stepRef.id, stepRef.getSnapshot().context]));
  });
  const hasSimulation = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => Boolean(snapshot.context.simulation));
  const isSimulationRunning = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => snapshot.matches('runningSimulation'));
  const processorMetrics = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => {
    var _snapshot$context$sim;
    return (_snapshot$context$sim = snapshot.context.simulation) === null || _snapshot$context$sim === void 0 ? void 0 : _snapshot$context$sim.processors_metrics;
  });
  const simulatorSteps = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => {
    return snapshot.context.steps;
  });
  const isAnyProcessorBeforePersisted = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => (0, _selectors.selectWhetherAnyProcessorBeforePersisted)(snapshot.context));
  const stepsProcessingSummary = (0, _react.useMemo)(() => {
    const summaryMap = new Map();
    Array.from(stepsContext.entries()).forEach(([stepId, stepContext]) => {
      if ((0, _streamlang.isActionBlock)(stepContext.step)) {
        var _processorMetrics$ste;
        const isParticipatingInSimulation = simulatorSteps.find(p => p.customIdentifier === stepId);
        const isFailing = Boolean(processorMetrics === null || processorMetrics === void 0 ? void 0 : (_processorMetrics$ste = processorMetrics[stepId]) === null || _processorMetrics$ste === void 0 ? void 0 : _processorMetrics$ste.errors.some(e => e.type === 'generic_simulation_failure'));
        const isPending = hasSimulation && !(processorMetrics !== null && processorMetrics !== void 0 && processorMetrics[stepId]);
        if (isAnyProcessorBeforePersisted) {
          summaryMap.set(stepId, 'disabled.processorBeforePersisted');
        } else if (!isParticipatingInSimulation) {
          if (stepContext.isNew) {
            summaryMap.set(stepId, 'skipped.followsProcessorBeingEdited');
          } else {
            summaryMap.set(stepId, 'skipped.createdInPreviousSimulation');
          }
        } else if (isSimulationRunning) {
          summaryMap.set(stepId, 'running');
        } else if (!hasSimulation || isPending) {
          summaryMap.set(stepId, 'pending');
        } else if (isFailing) {
          summaryMap.set(stepId, 'failed');
        } else {
          summaryMap.set(stepId, 'successful');
        }
      }
    });
    return summaryMap;
  }, [hasSimulation, isAnyProcessorBeforePersisted, isSimulationRunning, processorMetrics, simulatorSteps, stepsContext]);
  return stepsProcessingSummary;
};
exports.useStepsProcessingSummary = useStepsProcessingSummary;