"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectPreviewRecords = exports.selectOriginalPreviewRecords = exports.selectHasSimulatedRecords = void 0;
var _reselect = require("reselect");
var _objectUtils = require("@kbn/object-utils");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Selects the documents used for the data preview table.
 */
const selectPreviewRecords = exports.selectPreviewRecords = (0, _reselect.createSelector)([context => context.samples, context => context.previewDocsFilter, context => {
  var _context$simulation;
  return (_context$simulation = context.simulation) === null || _context$simulation === void 0 ? void 0 : _context$simulation.documents;
}], (samples, previewDocsFilter, documents) => {
  if (!previewDocsFilter || !documents) {
    return samples.map(sample => (0, _objectUtils.flattenObjectNestedLast)(sample.document));
  }
  const filterFn = (0, _utils.getFilterSimulationDocumentsFn)(previewDocsFilter);
  return documents.filter(filterFn).map(doc => doc.value);
});
const selectOriginalPreviewRecords = exports.selectOriginalPreviewRecords = (0, _reselect.createSelector)([context => context.samples, context => context.previewDocsFilter, context => {
  var _context$simulation2;
  return (_context$simulation2 = context.simulation) === null || _context$simulation2 === void 0 ? void 0 : _context$simulation2.documents;
}], (samples, previewDocsFilter, documents) => {
  if (!previewDocsFilter || !documents) {
    return samples;
  }
  const filterFn = (0, _utils.getFilterSimulationDocumentsFn)(previewDocsFilter);
  // return the samples where the filterFn matches the documents at the same index
  return samples.filter((_, index) => filterFn(documents[index]));
});
const selectHasSimulatedRecords = exports.selectHasSimulatedRecords = (0, _reselect.createSelector)([context => {
  var _context$simulation3;
  return (_context$simulation3 = context.simulation) === null || _context$simulation3 === void 0 ? void 0 : _context$simulation3.documents;
}], documents => {
  return Boolean(documents && documents.length > 0);
});