"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewFlyout = exports.FLYOUT_WIDTH_KEY = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/shared/preview_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FLYOUT_WIDTH_KEY = exports.FLYOUT_WIDTH_KEY = 'streamsEnrichment:flyoutWidth';
const PreviewFlyout = ({
  currentDoc,
  hits,
  setExpandedDoc,
  docViewsRegistry,
  streamName
}) => {
  const {
    core,
    dependencies
  } = (0, _use_kibana.useKibana)();
  const {
    data
  } = dependencies.start;
  const {
    value: streamDataView
  } = (0, _useAsync.default)(() => data.dataViews.create({
    title: streamName,
    timeFieldName: '@timestamp'
  }));
  return currentDoc && streamDataView && /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewerFlyout, {
    "data-test-subj": "esqlRowDetailsFlyout",
    flyoutWidthLocalStorageKey: FLYOUT_WIDTH_KEY,
    flyoutType: 'push',
    services: {
      toastNotifications: core.notifications.toasts
    },
    isEsqlQuery: false,
    hit: currentDoc,
    hits: hits,
    dataView: streamDataView,
    docViewsRegistry: docViewsRegistry,
    columns: [],
    onAddColumn: () => {},
    onRemoveColumn: () => {},
    onClose: () => {
      setExpandedDoc(undefined);
    },
    setExpandedDoc: doc => {
      // find the expanded document in the hits array
      const expandedDoc = hits.find(hit => hit.id === (doc === null || doc === void 0 ? void 0 : doc.id));
      // if the document is found, set it as the expanded document
      if (expandedDoc) {
        setExpandedDoc(expandedDoc);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  });
};
exports.PreviewFlyout = PreviewFlyout;