"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyPostProcessing = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This can be used to apply any post-processing directly to the ingest pipeline processors.
const applyPostProcessing = processors => {
  return processors.map(processor => {
    if ('grok' in processor && processor.grok) {
      return {
        grok: {
          ...processor.grok,
          // Use v1 patterns
          ecs_compatibility: 'v1'
        }
      };
    }
    return processor;
  });
};
exports.applyPostProcessing = applyPostProcessing;