"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetSeverity = void 0;
var _react = require("react");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetSeverity = ({
  http,
  toastNotifications,
  actionConnector
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [severity, setSeverity] = (0, _react.useState)([]);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  (0, _react.useEffect)(() => {
    let didCancel = false;
    const fetchData = async () => {
      if (!actionConnector) {
        setIsLoading(false);
        return;
      }
      abortCtrl.current = new AbortController();
      setIsLoading(true);
      try {
        const res = await (0, _api.getSeverity)({
          http,
          signal: abortCtrl.current.signal,
          connectorId: actionConnector.id
        });
        if (!didCancel) {
          var _res$data;
          setIsLoading(false);
          setSeverity((_res$data = res.data) !== null && _res$data !== void 0 ? _res$data : []);
          if (res.status && res.status === 'error') {
            var _res$serviceMessage;
            toastNotifications.addDanger({
              title: i18n.SEVERITY_API_ERROR,
              text: `${(_res$serviceMessage = res.serviceMessage) !== null && _res$serviceMessage !== void 0 ? _res$serviceMessage : res.message}`
            });
          }
        }
      } catch (error) {
        if (!didCancel) {
          setIsLoading(false);
          toastNotifications.addDanger({
            title: i18n.SEVERITY_API_ERROR,
            text: error.message
          });
        }
      }
    };
    abortCtrl.current.abort();
    fetchData();
    return () => {
      didCancel = true;
      setIsLoading(false);
      abortCtrl.current.abort();
    };
  }, [http, actionConnector, toastNotifications]);
  return {
    severity,
    isLoading
  };
};
exports.useGetSeverity = useGetSeverity;