"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERIFICATION_MODE_NONE = exports.VERIFICATION_MODE_LABEL = exports.VERIFICATION_MODE_FULL = exports.VERIFICATION_MODE_DESC = exports.VERIFICATION_MODE_CERTIFICATE = exports.USE_NATIVE_FUNCTION_CALLING_LABEL = exports.USE_NATIVE_FUNCTION_CALLING_DESC = exports.USAGE_DASHBOARD_LINK = exports.URL_LABEL = exports.PROJECT_ID_LABEL = exports.PKI_MODE_LABEL = exports.OTHER_OPENAI = exports.ORG_ID_LABEL = exports.OPENAI = exports.KEY_DATA_LABEL = exports.KEY_DATA_DESC = exports.INVALID_ACTION = exports.DOCUMENTATION = exports.DEFAULT_MODEL_LABEL = exports.CERT_DATA_LABEL = exports.CERT_DATA_DESC = exports.CA_DATA_LABEL = exports.CA_DATA_DESC = exports.BODY_REQUIRED = exports.BODY_INVALID = exports.AZURE_AI = exports.API_URL_LABEL = exports.API_PROVIDER_REQUIRED = exports.API_PROVIDER_LABEL = exports.API_KEY_LABEL = exports.ACTION_REQUIRED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL_LABEL = exports.API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.apiUrlTextFieldLabel', {
  defaultMessage: 'URL'
});
const API_KEY_LABEL = exports.API_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.apiKeySecret', {
  defaultMessage: 'API key'
});
const DEFAULT_MODEL_LABEL = exports.DEFAULT_MODEL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.defaultModelTextFieldLabel', {
  defaultMessage: 'Default model'
});
const ORG_ID_LABEL = exports.ORG_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.orgIdTextFieldLabel', {
  defaultMessage: 'OpenAI Organization'
});
const PROJECT_ID_LABEL = exports.PROJECT_ID_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.projectIdTextFieldLabel', {
  defaultMessage: 'OpenAI Project'
});
const API_PROVIDER_LABEL = exports.API_PROVIDER_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.apiProviderLabel', {
  defaultMessage: 'Select an OpenAI provider'
});
const OPENAI = exports.OPENAI = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.openAi', {
  defaultMessage: 'OpenAI'
});
const AZURE_AI = exports.AZURE_AI = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.azureAi', {
  defaultMessage: 'Azure OpenAI'
});
const OTHER_OPENAI = exports.OTHER_OPENAI = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.otherAi', {
  defaultMessage: 'Other (OpenAI Compatible Service)'
});
const DOCUMENTATION = exports.DOCUMENTATION = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.documentation', {
  defaultMessage: 'documentation'
});
const CERT_DATA_LABEL = exports.CERT_DATA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.certificateDataLabel', {
  defaultMessage: 'Certificate file'
});
const CERT_DATA_DESC = exports.CERT_DATA_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.certificateDataDocumentation', {
  defaultMessage: 'Raw PKI certificate content (PEM format) for cloud or on-premise deployments.'
});
const KEY_DATA_LABEL = exports.KEY_DATA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.privateKeyDataLabel', {
  defaultMessage: 'Private key file'
});
const KEY_DATA_DESC = exports.KEY_DATA_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.privateKeyDataDocumentation', {
  defaultMessage: 'Raw PKI private key content (PEM format) for cloud or on-premise deployments.'
});
const VERIFICATION_MODE_LABEL = exports.VERIFICATION_MODE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.verificationModeLabel', {
  defaultMessage: 'SSL verification mode'
});
const VERIFICATION_MODE_DESC = exports.VERIFICATION_MODE_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.verificationModeDocumentation', {
  defaultMessage: 'Controls SSL/TLS certificate verification: `Full` verifies both certificate and hostname, `Certificate` verifies the certificate but not the hostname, `None` skips all verification. Use `None` cautiously for testing purposes.'
});
const VERIFICATION_MODE_FULL = exports.VERIFICATION_MODE_FULL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.verificationModeFullLabel', {
  defaultMessage: 'Full (Certificate and Hostname)'
});
const VERIFICATION_MODE_CERTIFICATE = exports.VERIFICATION_MODE_CERTIFICATE = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.verificationModeCertificateLabel', {
  defaultMessage: 'Certificate Only'
});
const VERIFICATION_MODE_NONE = exports.VERIFICATION_MODE_NONE = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.verificationModeNoneLabel', {
  defaultMessage: 'None (Skip Verification)'
});
const URL_LABEL = exports.URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.urlTextFieldLabel', {
  defaultMessage: 'URL'
});
const BODY_REQUIRED = exports.BODY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.error.requiredGenerativeAiBodyText', {
  defaultMessage: 'Body is required.'
});
const BODY_INVALID = exports.BODY_INVALID = _i18n.i18n.translate('xpack.stackConnectors.security.genAi.params.error.invalidBodyText', {
  defaultMessage: 'Body does not have a valid JSON format.'
});
const ACTION_REQUIRED = exports.ACTION_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.security.genAi.params.error.requiredActionText', {
  defaultMessage: 'Action is required.'
});
const INVALID_ACTION = exports.INVALID_ACTION = _i18n.i18n.translate('xpack.stackConnectors.security.genAi.params.error.invalidActionText', {
  defaultMessage: 'Invalid action name.'
});
const API_PROVIDER_REQUIRED = exports.API_PROVIDER_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.error.requiredApiProviderText', {
  defaultMessage: 'API provider is required.'
});
const USAGE_DASHBOARD_LINK = (apiProvider, connectorName) => _i18n.i18n.translate('xpack.stackConnectors.components.genAi.dashboardLink', {
  values: {
    apiProvider,
    connectorName
  },
  defaultMessage: 'View {apiProvider} Usage Dashboard for "{ connectorName }" Connector'
});
exports.USAGE_DASHBOARD_LINK = USAGE_DASHBOARD_LINK;
const PKI_MODE_LABEL = exports.PKI_MODE_LABEL = _i18n.i18n.translate('xpack.stackConnectors.genAi.pkiModeLabel', {
  defaultMessage: 'Enable PKI Authentication'
});
const CA_DATA_LABEL = exports.CA_DATA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.caDataLabel', {
  defaultMessage: 'CA certificate file'
});
const CA_DATA_DESC = exports.CA_DATA_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.caDataDocumentation', {
  defaultMessage: 'Raw CA certificate content (PEM) used to verify the server certificate.'
});
const USE_NATIVE_FUNCTION_CALLING_LABEL = exports.USE_NATIVE_FUNCTION_CALLING_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.enableNativeFunctionCallingLabel', {
  defaultMessage: 'Enable native function calling'
});
const USE_NATIVE_FUNCTION_CALLING_DESC = exports.USE_NATIVE_FUNCTION_CALLING_DESC = _i18n.i18n.translate('xpack.stackConnectors.components.genAi.enableNativeFunctionCallingDescription', {
  defaultMessage: 'Enable when the model supports native function calling in the chat completions API.'
});