"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChoices = void 0;
var _react = require("react");
var _use_get_choices = require("./use_get_choices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useChoices = ({
  http,
  actionConnector,
  toastNotifications,
  fields
}) => {
  const defaultFields = (0, _react.useMemo)(() => fields.reduce((acc, field) => ({
    ...acc,
    [field]: []
  }), {}), [fields]);
  const [choices, setChoices] = (0, _react.useState)(defaultFields);
  const onChoicesSuccess = (0, _react.useCallback)(values => {
    setChoices(values.reduce((acc, value) => {
      var _acc$value$element;
      return {
        ...acc,
        [value.element]: [...((_acc$value$element = acc[value.element]) !== null && _acc$value$element !== void 0 ? _acc$value$element : []), value]
      };
    }, defaultFields));
  }, [defaultFields]);
  const {
    isLoading
  } = (0, _use_get_choices.useGetChoices)({
    http,
    toastNotifications,
    actionConnector,
    fields,
    onSuccess: onChoicesSuccess
  });
  return {
    choices,
    isLoading
  };
};
exports.useChoices = useChoices;