"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _header_type_options = require("./header_type_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/common/auth/header_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const HeaderFields = ({
  readOnly,
  maxHeaders
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": "webhookHeaderText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, i18n.HEADERS_TITLE)), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseArray, {
    path: "__internal__.headers",
    initialNumberOfItems: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, ({
    addItem,
    items,
    removeItem
  }) => {
    const limitOfHeaderExceeded = items.length >= maxHeaders;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 19
      }
    }, i18n.HEADERS_SUBTITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 17
      }
    }, !limitOfHeaderExceeded && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      onClick: addItem,
      "data-test-subj": "webhookAddHeaderButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 21
      }
    }, i18n.ADD_BUTTON))), limitOfHeaderExceeded && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      style: {
        marginTop: 8
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 17
      }
    }, i18n.MAX_HEADERS_LIMIT(maxHeaders)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 15
      }
    }), items.map(item => /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
      key: item.id,
      path: `${item.path}.type`,
      config: {
        defaultValue: _header_type_options.headerTypeOptions[0].value
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 17
      }
    }, typeField => {
      const headerTypeValue = typeField.value;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 23
        }
      }, headerTypeValue === 'secret' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        css: (0, _react2.css)`
                                  max-width: fit-content;
                                `,
        "data-test-subj": "encryptedHeadersBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 31
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _react2.css)`
                                    margin-right: 5px;
                                  `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 33
        }
      }, i18n.ENCRYPTED_HEADERS_BADGE), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "info",
        size: "s",
        content: i18n.ENCRYPTED_HEADERS_TOOLTIP_CONTENT,
        position: "top",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 33
        }
      }))), ' '), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasBorder: true,
        hasShadow: false,
        css: {
          marginBottom: '20px',
          background: headerTypeValue === 'secret' ? euiTheme.colors.backgroundBaseSubdued : euiTheme.colors.backgroundBasePlain,
          display: 'flex',
          flexDirection: 'column'
        },
        "data-test-subj": "webhookHeaderPanel",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
        path: `${item.path}.key`,
        config: {
          label: i18n.KEY_LABEL,
          validations: [{
            validator: emptyField(i18n.HEADER_MISSING_KEY_ERROR)
          }, {
            validator: ({
              value,
              form,
              path
            }) => {
              var _form$getFormData$__i, _form$getFormData$__i2;
              if (!value) return;
              const headers = (_form$getFormData$__i = (_form$getFormData$__i2 = form.getFormData().__internal__) === null || _form$getFormData$__i2 === void 0 ? void 0 : _form$getFormData$__i2.headers) !== null && _form$getFormData$__i !== void 0 ? _form$getFormData$__i : [];
              const duplicates = headers.filter((header, id) => header.key === value && `${path}` !== `__internal__.headers[${id}].key`);
              if (duplicates.length > 0) {
                return {
                  message: i18n.SAME_HEADER_KEY_ERROR
                };
              }
            }
          }]
        },
        component: _components.TextField,
        componentProps: {
          euiFieldProps: {
            readOnly,
            'data-test-subj': 'webhookHeadersKeyInput'
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 31
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
        path: `${item.path}.value`,
        config: {
          label: i18n.VALUE_LABEL,
          validations: [{
            validator: emptyField(i18n.HEADER_MISSING_VALUE_ERROR)
          }]
        },
        component: headerTypeValue === 'secret' ? _components.PasswordField : _components.TextField,
        componentProps: {
          euiFieldProps: {
            readOnly,
            'data-test-subj': headerTypeValue === 'secret' ? 'webhookHeadersSecretValueInput' : 'webhookHeadersValueInput',
            type: headerTypeValue === 'secret' ? 'dual' : 'text'
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 31
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: i18n.HEADER_TYPE_LABEL,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 31
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
        options: _header_type_options.headerTypeOptions,
        valueOfSelected: headerTypeValue,
        onChange: val => typeField.setValue(val),
        hasDividers: true,
        fullWidth: true,
        "data-test-subj": "webhookHeaderTypeSelect",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 33
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        color: "danger",
        onClick: () => removeItem(item.id),
        iconType: "minusInCircle",
        "aria-label": i18n.DELETE_BUTTON,
        "data-test-subj": "webhookRemoveHeaderButton",
        css: {
          marginTop: '28px',
          background: euiTheme.colors.backgroundBaseDanger
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 31
        }
      })))));
    })));
  }));
};
exports.HeaderFields = HeaderFields;