"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasAuthSchema = exports.authTypeSchema = exports.SecretConfigurationSchemaValidation = exports.SecretConfigurationSchema = exports.SecretConfiguration = exports.AuthConfiguration = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const authTypeSchema = exports.authTypeSchema = _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.AuthType.Basic), _configSchema.schema.literal(_constants.AuthType.SSL), _configSchema.schema.literal(_constants.AuthType.OAuth2ClientCredentials), _configSchema.schema.literal(null)], {
  defaultValue: _constants.AuthType.Basic
}));
const hasAuthSchema = exports.hasAuthSchema = _configSchema.schema.boolean({
  defaultValue: true
});
const HeadersSchema = _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string());
const AuthConfiguration = exports.AuthConfiguration = {
  hasAuth: hasAuthSchema,
  authType: authTypeSchema,
  certType: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.SSLCertType.CRT), _configSchema.schema.literal(_constants.SSLCertType.PFX)])),
  ca: _configSchema.schema.maybe(_configSchema.schema.string()),
  verificationMode: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('none'), _configSchema.schema.literal('certificate'), _configSchema.schema.literal('full')])),
  accessTokenUrl: _configSchema.schema.maybe(_configSchema.schema.string()),
  clientId: _configSchema.schema.maybe(_configSchema.schema.string()),
  scope: _configSchema.schema.maybe(_configSchema.schema.string()),
  additionalFields: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string()))
};
const SecretConfiguration = exports.SecretConfiguration = {
  user: _configSchema.schema.nullable(_configSchema.schema.string()),
  password: _configSchema.schema.nullable(_configSchema.schema.string()),
  crt: _configSchema.schema.nullable(_configSchema.schema.string()),
  key: _configSchema.schema.nullable(_configSchema.schema.string()),
  pfx: _configSchema.schema.nullable(_configSchema.schema.string()),
  clientSecret: _configSchema.schema.nullable(_configSchema.schema.string()),
  secretHeaders: _configSchema.schema.nullable(HeadersSchema)
};
const SecretConfigurationSchemaValidation = exports.SecretConfigurationSchemaValidation = {
  validate: secrets => {
    // user and password must be set together (or not at all)
    if (!secrets.password && !secrets.user && !secrets.crt && !secrets.key && !secrets.pfx && !secrets.clientSecret) {
      return;
    }
    if (secrets.password && secrets.user && !secrets.crt && !secrets.key && !secrets.pfx && !secrets.clientSecret) {
      return;
    }
    if (secrets.crt && secrets.key && !secrets.user && !secrets.pfx && !secrets.clientSecret) {
      return;
    }
    if (!secrets.crt && !secrets.key && !secrets.user && secrets.pfx && !secrets.clientSecret) {
      return;
    }
    if (!secrets.password && !secrets.user && !secrets.crt && !secrets.key && !secrets.pfx && secrets.clientSecret) {
      return;
    }
    return _i18n.i18n.translate('xpack.stackConnectors.webhook.invalidSecrets', {
      defaultMessage: 'must specify one of the following schemas: user and password; crt and key (with optional password); pfx (with optional password); or clientSecret (for OAuth2)'
    });
  }
};
const SecretConfigurationSchema = exports.SecretConfigurationSchema = _configSchema.schema.object(SecretConfiguration, SecretConfigurationSchemaValidation);