"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareToSpaceForm = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _share_mode_control = require("./share_mode_control");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/share_saved_objects_to_space/components/share_to_space_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ShareToSpaceForm = props => {
  const {
    spaces,
    objectNoun,
    onUpdate,
    shareOptions,
    showCreateCopyCallout,
    canShareToAllSpaces,
    makeCopy,
    enableCreateNewSpaceLink,
    enableSpaceAgnosticBehavior,
    prohibitedSpaces
  } = props;
  const setSelectedSpaceIds = selectedSpaceIds => onUpdate({
    ...shareOptions,
    selectedSpaceIds
  });
  const createCopyCallout = showCreateCopyCallout ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.shareToSpace.shareWarningTitle",
      defaultMessage: "Changes are synchronized across spaces",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    }),
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.shareToSpace.shareWarningBody",
    defaultMessage: "Your changes appear in each space you select. {makeACopyLink} if you don't want to synchronize your changes.",
    values: {
      makeACopyLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "sts-copy-button",
        onClick: () => makeCopy(),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.shareToSpace.shareWarningLink",
        defaultMessage: "Make a copy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  })) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, createCopyCallout, /*#__PURE__*/_react.default.createElement(_share_mode_control.ShareModeControl, {
    spaces: spaces,
    objectNoun: objectNoun,
    canShareToAllSpaces: canShareToAllSpaces,
    shareOptions: shareOptions,
    onChange: selection => setSelectedSpaceIds(selection),
    enableCreateNewSpaceLink: enableCreateNewSpaceLink,
    enableSpaceAgnosticBehavior: enableSpaceAgnosticBehavior,
    prohibitedSpaces: prohibitedSpaces,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }));
};
exports.ShareToSpaceForm = ShareToSpaceForm;