"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AliasTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _space_avatar = require("../../space_avatar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/spaces/public/share_saved_objects_to_space/components/alias_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const AliasTable = ({
  spaces,
  aliasesToDisable
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(5);
  const spacesMap = (0, _react.useMemo)(() => spaces.reduce((acc, space) => acc.set(space.id, space), new Map()), [spaces]);
  const filteredAliasesToDisable = (0, _react.useMemo)(() => aliasesToDisable.filter(({
    spaceExists
  }) => spaceExists), [aliasesToDisable]);
  const aliasesToDisableCount = filteredAliasesToDisable.length;
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: aliasesToDisableCount,
    pageSizeOptions: [5, 10, 15, 20]
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.shareToSpace.aliasTableCalloutTitle",
      defaultMessage: "Legacy URL conflict",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }),
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.shareToSpace.aliasTableCalloutBody",
    defaultMessage: "{aliasesToDisableCount, plural, one {# legacy URL} other {# legacy URLs}} will be disabled.",
    values: {
      aliasesToDisableCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 29
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: filteredAliasesToDisable,
    columns: [{
      name: 'Type',
      field: 'targetType',
      sortable: true
    }, {
      name: 'ID',
      field: 'sourceId',
      sortable: true,
      truncateText: true
    }, {
      name: 'Space',
      render: ({
        targetSpace
      }) => {
        const space = spacesMap.get(targetSpace); // it's safe to use ! here because we filtered only for aliases that are in spaces that exist
        return /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
          space: space,
          size: 's',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 26
          }
        }); // the whole table is wrapped in a Suspense
      },
      sortable: ({
        targetSpace
      }) => targetSpace
    }],
    sorting: true,
    pagination: pagination,
    onTableChange: ({
      page: {
        index,
        size
      }
    }) => {
      setPageIndex(index);
      setPageSize(size);
    },
    tableLayout: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }))));
};
exports.AliasTable = AliasTable;