"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSpaces = exports.SPACES_QUERY_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPACES_QUERY_KEY = exports.SPACES_QUERY_KEY = ['spaces'];
const useSpaces = (spacesManager, enabled = true) => {
  return (0, _reactQuery.useQuery)({
    queryKey: SPACES_QUERY_KEY,
    queryFn: () => spacesManager.getSpaces(),
    enabled
  });
};
exports.useSpaces = useSpaces;