"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyFeatureStatesSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _collapsible_lists = require("../../collapsible_lists");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/summaries/policies/policy_feature_states_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PolicyFeatureStatesSummary = ({
  includeGlobalState,
  featureStates
}) => {
  const hasGlobalStateButNoFeatureStates = includeGlobalState && featureStates === undefined;
  const hasNoFeatureStates = !featureStates || (featureStates === null || featureStates === void 0 ? void 0 : featureStates.includes(_constants.FEATURE_STATES_NONE_OPTION));
  const hasAllFeatureStates = hasGlobalStateButNoFeatureStates || (featureStates === null || featureStates === void 0 ? void 0 : featureStates.length) === 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "policyFeatureStatesSummary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.summary.policyFeatureStatesLabel",
    defaultMessage: "Include feature state {hasSpecificFeatures, plural, one {from} other {}}",
    values: {
      hasSpecificFeatures: !hasNoFeatureStates && !hasAllFeatureStates ? 1 : 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, !hasGlobalStateButNoFeatureStates && hasNoFeatureStates && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.summary.policyNoFeatureStatesLabel",
    defaultMessage: "No",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  }), hasAllFeatureStates && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.summary.policyAllFeatureStatesLabel",
    defaultMessage: "All features",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 13
    }
  }), !hasNoFeatureStates && !hasAllFeatureStates && /*#__PURE__*/_react.default.createElement(_collapsible_lists.CollapsibleFeatureStatesList, {
    featureStates: featureStates,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  }))));
};
exports.PolicyFeatureStatesSummary = PolicyFeatureStatesSummary;