"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetentionSettingsUpdateModalProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../app_context");
var _shared_imports = require("../../shared_imports");
var _constants = require("../constants");
var _http = require("../services/http");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/retention_update_modal_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RetentionSettingsUpdateModalProvider = ({
  children
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const toastNotifications = (0, _app_context.useToastNotifications)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [retentionSchedule, setRetentionSchedule] = (0, _react.useState)(_constants.DEFAULT_RETENTION_SCHEDULE);
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const [isAdvancedCronVisible, setIsAdvancedCronVisible] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const [simpleCron, setSimpleCron] = (0, _react.useState)({
    expression: _constants.DEFAULT_RETENTION_SCHEDULE,
    frequency: _constants.DEFAULT_RETENTION_FREQUENCY
  });
  const [fieldToPreferredValueMap, setFieldToPreferredValueMap] = (0, _react.useState)({});
  const [isInvalid, setIsInvalid] = (0, _react.useState)(false);
  const updateRetentionPrompt = (originalRetentionSchedule, onSuccess = () => undefined) => {
    setIsModalOpen(true);
    setIsAdvancedCronVisible(Boolean(originalRetentionSchedule && originalRetentionSchedule !== _constants.DEFAULT_RETENTION_SCHEDULE));
    if (originalRetentionSchedule) {
      setIsEditing(true);
      setRetentionSchedule(originalRetentionSchedule);
    }
    onSuccessCallback.current = onSuccess;
  };
  const closeModal = () => {
    setIsModalOpen(false);
  };
  const updateRetentionSetting = async () => {
    if (!retentionSchedule) {
      setIsInvalid(true);
      return;
    }
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await (0, _http.updateRetentionSchedule)(retentionSchedule);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
    } else {
      closeModal();
      toastNotifications.addSuccess(i18n.translate('xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionSuccessMessage', {
        defaultMessage: 'Retention schedule updated'
      }));
      if (onSuccessCallback.current) {
        onSuccessCallback.current();
      }
    }
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: closeModal,
      "aria-labelledby": modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }, isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionEditTitle",
      defaultMessage: "Edit retention schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionAddTitle",
      defaultMessage: "Add retention schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 9
      }
    }, saveError && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionErrorTitle",
        defaultMessage: "Error saving retention schedule",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 19
        }
      }),
      role: "alert",
      color: "danger",
      iconType: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 15
      }
    }, saveError.data && saveError.data.message ? /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 61
      }
    }, saveError.data.message) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 15
      }
    })), isAdvancedCronVisible ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionScheduleLabel",
        defaultMessage: "Retention schedule",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 19
        }
      }),
      isInvalid: isInvalid,
      error: i18n.translate('xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionScheduleFieldErrorMessage', {
        defaultMessage: 'Retention schedule is required.'
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionHelpText",
        defaultMessage: "Use cron expression. {docLink}",
        values: {
          docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.links.watcher.cronSchedule,
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 192,
              columnNumber: 25
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionHelpTextDocLinkText",
            defaultMessage: "Learn more.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 193,
              columnNumber: 27
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 19
        }
      }),
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: isInvalid,
      defaultValue: retentionSchedule,
      fullWidth: true,
      onChange: e => setRetentionSchedule(e.target.value),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setIsAdvancedCronVisible(false);
        setRetentionSchedule(simpleCron.expression);
      },
      "data-test-subj": "showBasicCronLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionBasicLabel",
      defaultMessage: "Create basic interval",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 19
      }
    })))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.CronEditor, {
      fieldToPreferredValueMap: fieldToPreferredValueMap,
      cronExpression: simpleCron.expression,
      frequency: simpleCron.frequency,
      onChange: ({
        cronExpression: expression,
        frequency,
        fieldToPreferredValueMap: newFieldToPreferredValueMap
      }) => {
        setSimpleCron({
          expression,
          frequency
        });
        setFieldToPreferredValueMap(newFieldToPreferredValueMap);
        setRetentionSchedule(expression);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setIsAdvancedCronVisible(true);
      },
      "data-test-subj": "showAdvancedCronLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionAdvancedLabel",
      defaultMessage: "Create cron expression",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: closeModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionCancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: updateRetentionSetting,
      fill: true,
      isLoading: isSaving,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 11
      }
    }, isEditing ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionEditButtonLabel",
      defaultMessage: "Save changes",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionSaveButtonLabel",
      defaultMessage: "Schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 15
      }
    }))));
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 5
    }
  }, children(updateRetentionPrompt), renderModal());
};
exports.RetentionSettingsUpdateModalProvider = RetentionSettingsUpdateModalProvider;