"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsibleDataStreamsList = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_collapsible_list = require("./use_collapsible_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/snapshot_restore/public/application/components/collapsible_lists/collapsible_data_streams_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CollapsibleDataStreamsList = ({
  dataStreams
}) => {
  const {
    isShowingFullList,
    setIsShowingFullList,
    items,
    hiddenItemsCount
  } = (0, _use_collapsible_list.useCollapsibleList)({
    items: dataStreams
  });
  return items === 'all' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.dataStreamsList.allDataStreamsValue",
    defaultMessage: "All data streams",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, items.map(dataStream => /*#__PURE__*/_react.default.createElement("div", {
    key: dataStream,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 15
    }
  }, dataStream))))), hiddenItemsCount ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => isShowingFullList ? setIsShowingFullList(false) : setIsShowingFullList(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, isShowingFullList ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.dataStreamsList.dataStreamsCollapseAllLink",
    defaultMessage: "Hide {count, plural, one {# data stream} other {# data streams}}",
    values: {
      count: hiddenItemsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.dataStreamsList.dataStreamsExpandAllLink",
    defaultMessage: "Show {count, plural, one {# data stream} other {# data streams}}",
    values: {
      count: hiddenItemsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 15
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: isShowingFullList ? 'arrowUp' : 'arrowDown',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }))) : null);
};
exports.CollapsibleDataStreamsList = CollapsibleDataStreamsList;