"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.summarySchema = exports.statusSchema = exports.remoteSchema = exports.metaSchema = exports.groupingsSchema = exports.groupSummarySchema = exports.errorBudgetSchema = exports.dateType = exports.dateRangeSchema = exports.allOrAnyStringOrArray = exports.allOrAnyString = exports.ALL_VALUE = void 0;
var _Either = require("fp-ts/Either");
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALL_VALUE = exports.ALL_VALUE = '*';
const allOrAnyString = exports.allOrAnyString = t.union([t.literal(ALL_VALUE), t.string]);
const allOrAnyStringOrArray = exports.allOrAnyStringOrArray = t.union([t.literal(ALL_VALUE), t.string, t.array(t.union([t.literal(ALL_VALUE), t.string]))]);
const dateType = exports.dateType = new t.Type('DateType', input => input instanceof Date, (input, context) => _Either.either.chain(t.string.validate(input, context), value => {
  const decoded = new Date(value);
  return isNaN(decoded.getTime()) ? t.failure(input, context) : t.success(decoded);
}), date => date.toISOString());
const errorBudgetSchema = exports.errorBudgetSchema = t.type({
  initial: t.number,
  consumed: t.number,
  remaining: t.number,
  isEstimated: t.boolean
});
const statusSchema = exports.statusSchema = t.union([t.literal('NO_DATA'), t.literal('HEALTHY'), t.literal('DEGRADING'), t.literal('VIOLATED')]);
const summarySchema = exports.summarySchema = t.intersection([t.type({
  status: statusSchema,
  sliValue: t.number,
  errorBudget: errorBudgetSchema,
  fiveMinuteBurnRate: t.number,
  oneHourBurnRate: t.number,
  oneDayBurnRate: t.number
}), t.partial({
  summaryUpdatedAt: t.union([t.string, t.null])
})]);
const groupingsSchema = exports.groupingsSchema = t.record(t.string, t.union([t.string, t.number]));
const metaSchema = exports.metaSchema = t.partial({
  synthetics: t.type({
    monitorId: t.string,
    locationId: t.string,
    configId: t.string
  })
});
const remoteSchema = exports.remoteSchema = t.type({
  remoteName: t.string,
  kibanaUrl: t.string
});
const groupSummarySchema = exports.groupSummarySchema = t.type({
  total: t.number,
  worst: t.type({
    sliValue: t.number,
    status: t.string,
    slo: t.intersection([t.type({
      id: t.string,
      instanceId: t.string,
      name: t.string
    }), t.partial({
      groupings: t.record(t.string, t.unknown)
    })])
  }),
  violated: t.number,
  healthy: t.number,
  degrading: t.number,
  noData: t.number
});
const dateRangeSchema = exports.dateRangeSchema = t.type({
  from: dateType,
  to: dateType
});