"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findSLOResponseSchema = exports.findSLOParamsSchema = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _Either = require("fp-ts/Either");
var t = _interopRequireWildcard(require("io-ts"));
var _slo = require("../slo");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortDirectionSchema = t.union([t.literal('asc'), t.literal('desc')]);
const sortBySchema = t.union([t.literal('error_budget_consumed'), t.literal('error_budget_remaining'), t.literal('sli_value'), t.literal('status'), t.literal('burn_rate_5m'), t.literal('burn_rate_1h'), t.literal('burn_rate_1d')]);
const searchAfterArraySchema = t.array(t.union([t.string, t.number]));
const searchAfterSchema = new t.Type('SearchAfter', input => Array.isArray(input) && input.length > 0 && input.every(item => typeof item === 'string' || typeof item === 'number'), (input, context) => _Either.either.chain(t.string.validate(input, context), value => {
  try {
    const parsedValue = JSON.parse(value);
    const decoded = searchAfterArraySchema.decode(parsedValue);
    if ((0, _Either.isRight)(decoded)) {
      return t.success(decoded.right);
    }
    return t.failure(input, context, 'Invalid searchAfter value, must be a JSON array of strings or numbers');
  } catch (err) {
    return t.failure(input, context, 'Invalid searchAfter value, must be a JSON array of strings or numbers');
  }
}), input => JSON.stringify(input));
const findSLOParamsSchema = exports.findSLOParamsSchema = t.partial({
  query: t.partial({
    filters: t.string,
    kqlQuery: t.string,
    // Used for page pagination
    page: t.string,
    perPage: t.string,
    sortBy: sortBySchema,
    sortDirection: sortDirectionSchema,
    hideStale: _ioTsUtils.toBooleanRt,
    // Used for cursor pagination, searchAfter is a JSON array
    searchAfter: searchAfterSchema,
    size: t.string
  })
});
const findSLOResponseSchema = exports.findSLOResponseSchema = t.intersection([t.type({
  page: t.number,
  perPage: t.number,
  total: t.number,
  results: t.array(_slo.sloWithDataResponseSchema)
}), t.partial({
  searchAfter: searchAfterArraySchema,
  size: t.number
})]);