"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSloBurnRates = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _get_burn_rates = require("../../services/get_burn_rates");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSloBurnRates = exports.getSloBurnRates = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /internal/observability/slos/{id}/_burn_rates',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_read']
    }
  },
  params: _sloSchema.getSLOBurnRatesParamsSchema,
  handler: async ({
    request,
    logger,
    params,
    plugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      scopedClusterClient,
      soClient,
      spaceId
    } = await getScopedClients({
      request,
      logger
    });
    const {
      instanceId,
      windows,
      remoteName
    } = params.body;
    return await (0, _get_burn_rates.getBurnRates)({
      instanceId,
      spaceId,
      windows,
      remoteName,
      sloId: params.path.id,
      services: {
        soClient,
        esClient: scopedClusterClient.asCurrentUser,
        logger
      }
    });
  }
});