"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.disableSLORoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _manage_slo = require("../../services/manage_slo");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const disableSLORoute = exports.disableSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'POST /api/observability/slos/{id}/disable 2023-10-31',
  options: {
    access: 'public'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_write']
    }
  },
  params: _sloSchema.manageSLOParamsSchema,
  handler: async ({
    context,
    response,
    request,
    params,
    logger,
    plugins,
    getScopedClients
  }) => {
    var _core$security$authc$;
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      repository,
      transformManager,
      summaryTransformManager
    } = await getScopedClients({
      request,
      logger
    });
    const core = await context.core;
    const userId = (_core$security$authc$ = core.security.authc.getCurrentUser()) === null || _core$security$authc$ === void 0 ? void 0 : _core$security$authc$.username;
    const manageSLO = new _manage_slo.ManageSLO(repository, transformManager, summaryTransformManager, userId);
    await manageSLO.disable(params.path.id);
    return response.noContent();
  }
});