"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeedbackButton = FeedbackButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/common/feedback_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SLO_FEEDBACK_LINK = 'https://ela.st/slo-feedback';
const feedbackButtonLabel = _i18n.i18n.translate('xpack.slo.featureFeedbackButtonLabel', {
  defaultMessage: 'Give feedback'
});
function FeedbackButton({
  disabled
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    "aria-label": feedbackButtonLabel,
    href: SLO_FEEDBACK_LINK,
    size: "s",
    iconType: "popout",
    iconSide: "right",
    target: "_blank",
    color: "primary",
    isDisabled: disabled,
    "data-test-subj": "sloFeedbackButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, feedbackButtonLabel);
}