"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloIndicatorTypeBadge = SloIndicatorTypeBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _paths = require("../../../../../common/locators/paths");
var _use_kibana = require("../../../../hooks/use_kibana");
var _convert_sli_apm_params_to_apm_app_deeplink_url = require("../../../../utils/slo/convert_sli_apm_params_to_apm_app_deeplink_url");
var _labels = require("../../../../utils/slo/labels");
var _use_url_search_state = require("../../hooks/use_url_search_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/badges/slo_indicator_type_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloIndicatorTypeBadge({
  slo
}) {
  var _useRouteMatch$isExac, _useRouteMatch;
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _use_kibana.useKibana)().services;
  const isSloPage = (_useRouteMatch$isExac = (_useRouteMatch = (0, _reactRouterDom.useRouteMatch)(_paths.SLOS_PATH)) === null || _useRouteMatch === void 0 ? void 0 : _useRouteMatch.isExact) !== null && _useRouteMatch$isExac !== void 0 ? _useRouteMatch$isExac : false;
  const {
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const handleNavigateToApm = () => {
    const url = (0, _convert_sli_apm_params_to_apm_app_deeplink_url.convertSliApmParamsToApmAppDeeplinkUrl)(slo);
    if (url) {
      navigateToUrl(basePath.prepend(url));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: _ => {
      if (isSloPage) {
        onStateChange({
          kqlQuery: `slo.indicator.type: ${slo.indicator.type}`
        });
      }
    },
    onMouseDown: e => {
      if (isSloPage) e.stopPropagation(); // stops propagation of metric onElementClick
    },
    onClickAriaLabel: _i18n.i18n.translate('xpack.slo.sloIndicatorTypeBadge.clickToFilter', {
      defaultMessage: 'Click to filter by {indicatorType} SLOs',
      values: {
        indicatorType: (0, _labels.toIndicatorTypeLabel)(slo.indicator.type)
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, (0, _labels.toIndicatorTypeLabel)(slo.indicator.type))), (_sloSchema.apmTransactionDurationIndicatorSchema.is(slo.indicator) || _sloSchema.apmTransactionErrorRateIndicatorSchema.is(slo.indicator)) && slo.indicator.params.service !== '' && slo.indicator.params.service !== _sloSchema.ALL_VALUE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      maxWidth: 100
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.slo.sloIndicatorTypeBadge.exploreInApm', {
      defaultMessage: 'View {service} details',
      values: {
        service: slo.indicator.params.service
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    onClick: handleNavigateToApm,
    onMouseDown: e => {
      e.stopPropagation(); // stops propagation of metric onElementClick
    },
    onClickAriaLabel: _i18n.i18n.translate('xpack.slo.indicatorTypeBadge.exploreInApm', {
      defaultMessage: 'View {service} details',
      values: {
        service: slo.indicator.params.service
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }, slo.indicator.params.service))));
}