"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloManagementBulkActions = SloManagementBulkActions;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _action_modal = require("../../../context/action_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_management/components/slo_management_bulk_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloManagementBulkActions({
  items,
  setSelectedItems
}) {
  const {
    triggerAction
  } = (0, _action_modal.useActionModal)();
  const popoverId = (0, _eui.useGeneratedHtmlId)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const resetSelectedItems = () => {
    setSelectedItems([]);
  };
  const panels = [{
    id: 0,
    hasFocus: false,
    items: [{
      'data-test-subj': 'sloSloManagementTableBulkDeleteButton',
      onClick: () => {
        triggerAction({
          items,
          type: 'bulk_delete',
          onConfirm: () => resetSelectedItems()
        });
        setIsOpen(false);
      },
      icon: 'trash',
      name: _i18n.i18n.translate('xpack.slo.sloManagementTable.sloSloManagementTableBulkDeleteButtonLabel', {
        defaultMessage: 'Delete'
      })
    }, {
      'data-test-subj': 'sloSloManagementTableBulkPurgeButton',
      icon: 'logstashOutput',
      onClick: () => {
        triggerAction({
          items,
          type: 'bulk_purge',
          onConfirm: () => resetSelectedItems()
        });
        setIsOpen(false);
      },
      name: _i18n.i18n.translate('xpack.slo.sloManagementTable.sloSloManagementTableBulkPurgeButtonLabel', {
        defaultMessage: 'Purge Rollup Data'
      })
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: popoverId,
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "sloManagementTableBulkMenuButton",
      css: {
        blockSize: '16px',
        marginBottom: '5px'
      },
      size: "xs",
      onClick: () => setIsOpen(curr => !curr),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.slo.sloManagementTable.selectedSLOsButton', {
      defaultMessage: 'Selected {count} {count, plural, =1 {SLO} other {SLOs}}',
      values: {
        count: items.length
      }
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowDown",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    })),
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    anchorPosition: "downLeft",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    size: "s",
    panels: panels,
    "data-test-subj": "detailsCollapsedActionPanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }));
}