"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByField = GroupByField;
exports.canGroupBy = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _group_by_cardinality = require("./group_by_cardinality");
var _group_by_field_selector = require("./group_by_field_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/group_by_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function GroupByField({
  dataView,
  isLoading,
  filters
}) {
  var _dataView$fields$filt, _dataView$fields;
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const groupByFields = (_dataView$fields$filt = dataView === null || dataView === void 0 ? void 0 : (_dataView$fields = dataView.fields) === null || _dataView$fields === void 0 ? void 0 : _dataView$fields.filter(field => canGroupBy(field))) !== null && _dataView$fields$filt !== void 0 ? _dataView$fields$filt : [];
  const index = watch('indicator.params.index');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_group_by_field_selector.GroupByFieldSelector, {
    indexFields: groupByFields,
    isLoading: !!index && isLoading,
    isDisabled: !index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_group_by_cardinality.GroupByCardinality, {
    customFilters: filters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }));
}
const canGroupBy = field => {
  var _field$esTypes;
  const isAggregatable = field.aggregatable;
  const isNotDate = field.type !== 'date';
  // handles multi fields where there are multi es types, which could include 'text'
  // text fields break the transforms so we must ensure that the field is only a keyword
  const isOnlyKeyword = ((_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.length) === 1 && field.esTypes[0] === 'keyword';
  return isAggregatable && isNotDate && isOnlyKeyword;
};
exports.canGroupBy = canGroupBy;