"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByCardinality = GroupByCardinality;
var _sloSchema = require("@kbn/slo-schema");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_fetch_group_by_cardinality = require("../../../../hooks/use_fetch_group_by_cardinality");
var _groupings = require("../../../../utils/slo/groupings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/group_by_cardinality.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function GroupByCardinality({
  titleAppend,
  customFilters
}) {
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const index = watch('indicator.params.index');
  const filters = watch('indicator.params.filter');
  const timestampField = watch('indicator.params.timestampField');
  const groupByField = watch('groupBy');
  const {
    isLoading: isGroupByCardinalityLoading,
    data: groupByCardinality
  } = (0, _use_fetch_group_by_cardinality.useFetchGroupByCardinality)(index, timestampField, groupByField, customFilters || filters);
  const groupBy = [groupByField].flat().filter(value => !!value);
  const hasGroupBy = !groupBy.includes(_sloSchema.ALL_VALUE) && groupBy.length;
  if (!hasGroupBy) {
    return null;
  }
  if (isGroupByCardinalityLoading && !groupByCardinality) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 40
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 12
      }
    });
  }
  if (!groupByCardinality) {
    return null;
  }
  const cardinalityMessage = _i18n.i18n.translate('xpack.slo.sloEdit.groupBy.cardinalityInfo', {
    defaultMessage: 'Selected group by field {groupBy} will generate at least {card} SLO instances based on the last 24h sample data.',
    values: {
      card: groupByCardinality.cardinality,
      groupBy: (0, _groupings.getGroupKeysProse)(groupByField)
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: groupByCardinality.isHighCardinality ? 'warning' : '',
    color: groupByCardinality.isHighCardinality ? 'warning' : 'primary',
    title: titleAppend ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, titleAppend, " ", cardinalityMessage) : cardinalityMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  });
}