"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EquivalentApiRequest = EquivalentApiRequest;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _process_slo_form_values = require("../../helpers/process_slo_form_values");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/equivalent_api_request.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function EquivalentApiRequest({
  disabled,
  isEditMode,
  slo
}) {
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const {
    getValues,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const [sloData, setSloData] = (0, _react.useState)();
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  (0, _react.useEffect)(() => {
    if (!isFlyoutVisible) {
      return;
    }
    trigger().then(isValid => {
      if (isValid) {
        setSloData((0, _process_slo_form_values.transformCreateSLOFormToCreateSLOInput)(getValues()));
      }
    });
  }, [getValues, trigger, isFlyoutVisible]);
  let flyout;
  if (isFlyoutVisible) {
    flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      "aria-labelledby": flyoutTitleId,
      ownFocus: true,
      onClose: () => setIsFlyoutVisible(false),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: flyoutTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.equivalentApiRequest.h2.equivalentAPIRequestToLabel', {
      defaultMessage: 'Equivalent API request'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.equivalentApiRequest.p.useTheRESTAPILabel",
      defaultMessage: "Use the REST API",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "javascript",
      isCopyable: true,
      paddingSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, isEditMode ? `PUT /api/observability/slos/${slo.id}` : 'POST /api/observability/slos'), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.equivalentApiRequest.p.withTheFollowingBodyLabel",
      defaultMessage: "with the following body:",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 13
      }
    })), sloData ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true,
      paddingSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }, JSON.stringify(sloData, null, 2)) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "javascript",
      isCopyable: true,
      paddingSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.slo.equivalentApiRequest.formIsNotValidCodeBlockLabel', {
      defaultMessage: 'Form is not valid'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11yEquivalentApiRequestCloseButton",
      iconType: "cross",
      onClick: () => setIsFlyoutVisible(false),
      flush: "left",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.slo.equivalentApiRequest.closeButtonEmptyLabel', {
      defaultMessage: 'Close'
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    iconType: "copyClipboard",
    "data-test-subj": "sloFormCopyJsonButton",
    disabled: disabled,
    onClick: () => setIsFlyoutVisible(true),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.slo.sloEdit.equivalentApiRequest', {
    defaultMessage: 'Equivalent API request'
  })), flyout);
}