"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDetailsPage = SloDetailsPage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _dedent = _interopRequireDefault(require("dedent"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _ebtTools = require("@kbn/ebt-tools");
var _loading_state = require("../../components/loading_state");
var _paths = require("../../../common/locators/paths");
var _header_menu = require("../../components/header_menu/header_menu");
var _auto_refresh_button = require("../../components/slo/auto_refresh_button");
var _use_auto_refresh_storage = require("../../components/slo/auto_refresh_button/hooks/use_auto_refresh_storage");
var _use_fetch_slo_details = require("../../hooks/use_fetch_slo_details");
var _use_kibana = require("../../hooks/use_kibana");
var _use_license = require("../../hooks/use_license");
var _use_permissions = require("../../hooks/use_permissions");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _ = _interopRequireDefault(require("../404"));
var _header_control = require("./components/header_control");
var _header_title = require("./components/header_title");
var _slo_details = require("./components/slo_details");
var _use_get_query_params = require("./hooks/use_get_query_params");
var _use_selected_tab = require("./hooks/use_selected_tab");
var _use_slo_details_tabs = require("./hooks/use_slo_details_tabs");
var _action_modal = require("../../context/action_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/slo_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloDetailsPage() {
  var _slo$name;
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    },
    observabilityAIAssistant,
    serverless
  } = (0, _use_kibana.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const hasRightLicense = hasAtLeast('platinum');
  const {
    data: permissions
  } = (0, _use_permissions.usePermissions)();
  const {
    sloId
  } = (0, _reactRouterDom.useParams)();
  const {
    instanceId: sloInstanceId,
    remoteName
  } = (0, _use_get_query_params.useGetQueryParams)();
  const {
    storeAutoRefreshState,
    getAutoRefreshState
  } = (0, _use_auto_refresh_storage.useAutoRefreshStorage)();
  const [isAutoRefreshing, setIsAutoRefreshing] = (0, _react.useState)(getAutoRefreshState());
  const {
    isLoading,
    data: slo,
    isRefetching
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId,
    remoteName,
    instanceId: sloInstanceId,
    shouldRefetch: isAutoRefreshing
  });
  const isDeleting = Boolean((0, _reactQuery.useIsMutating)(['deleteSlo']));
  const {
    selectedTabId
  } = (0, _use_selected_tab.useSelectedTab)();
  const {
    tabs
  } = (0, _use_slo_details_tabs.useSloDetailsTabs)({
    slo,
    isAutoRefreshing,
    selectedTabId
  });
  (0, _react.useEffect)(() => {
    if (!slo || !observabilityAIAssistant) {
      return;
    }
    return observabilityAIAssistant.service.setScreenContext({
      screenDescription: (0, _dedent.default)(`
        The user is looking at the detail page for the following SLO

        Name: ${slo.name}.
        Id: ${slo.id}
        Instance Id: ${slo.instanceId}
        Description: ${slo.description}
        Observed value: ${slo.summary.sliValue}
        Error budget remaining: ${slo.summary.errorBudget.remaining}
        Status: ${slo.summary.status}
      `),
      data: [{
        name: 'slo',
        description: 'The SLO and its metadata',
        value: slo
      }]
    });
  }, [observabilityAIAssistant, slo]);
  (0, _react.useEffect)(() => {
    if (hasRightLicense === false || (permissions === null || permissions === void 0 ? void 0 : permissions.hasAllReadRequested) === false) {
      navigateToUrl(basePath.prepend(_paths.paths.slosWelcome));
    }
  }, [hasRightLicense, permissions, navigateToUrl, basePath]);
  (0, _ebtTools.usePageReady)({
    isReady: !isLoading && slo !== undefined,
    isRefreshing: isRefetching,
    meta: {
      description: '[ttfmp_slos] The SLO details page has loaded and SLO data is present.'
    }
  });
  (0, _public.useBreadcrumbs)(getBreadcrumbs(basePath, slo), {
    serverless
  });
  const isSloNotFound = !isLoading && slo === undefined;
  if (isSloNotFound) {
    return /*#__PURE__*/_react.default.createElement(_.default, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 12
      }
    });
  }
  const isPerformingAction = isLoading || isDeleting;
  const handleToggleAutoRefresh = () => {
    setIsAutoRefreshing(!isAutoRefreshing);
    storeAutoRefreshState(!isAutoRefreshing);
  };
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: (_slo$name = slo === null || slo === void 0 ? void 0 : slo.name) !== null && _slo$name !== void 0 ? _slo$name : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 1,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 33
        }
      }),
      children: /*#__PURE__*/_react.default.createElement(_header_title.HeaderTitle, {
        isLoading: isPerformingAction,
        slo: slo,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 19
        }
      }),
      rightSideItems: !isLoading ? [/*#__PURE__*/_react.default.createElement(_action_modal.ActionModalProvider, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_header_control.HeaderControl, {
        slo: slo,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_auto_refresh_button.AutoRefreshButton, {
        isAutoRefreshing: isAutoRefreshing,
        onClick: handleToggleAutoRefresh,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 15
        }
      })] : undefined,
      tabs
    },
    "data-test-subj": "sloDetailsPage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }), isLoading ? /*#__PURE__*/_react.default.createElement(_loading_state.LoadingState, {
    dataTestSubj: "sloDetailsLoading",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_slo_details.SloDetails, {
    slo: slo,
    isAutoRefreshing: isAutoRefreshing,
    selectedTabId: selectedTabId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }));
}
function getBreadcrumbs(basePath, slo) {
  var _slo$name2;
  return [{
    href: basePath.prepend(_paths.paths.slos),
    text: _i18n.i18n.translate('xpack.slo.breadcrumbs.slosLinkText', {
      defaultMessage: 'SLOs'
    }),
    deepLinkId: 'slo'
  }, {
    text: (_slo$name2 = slo === null || slo === void 0 ? void 0 : slo.name) !== null && _slo$name2 !== void 0 ? _slo$name2 : _i18n.i18n.translate('xpack.slo.breadcrumbs.sloDetailsLinkText', {
      defaultMessage: 'Details'
    })
  }];
}