"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsIndicatorOverview = SyntheticsIndicatorOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _use_kibana = require("../../../../hooks/use_kibana");
var _definition_item = require("../definition/definition_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/overview/synthetics_indicator_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SyntheticsIndicatorOverview({
  slo
}) {
  var _slo$meta;
  const {
    share: {
      url: {
        locators
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const monitorLocator = locators.get(_common.syntheticsMonitorDetailLocatorID);
  const regionLocator = locators.get(_common.syntheticsMonitorLocationQueryLocatorID);
  const {
    'monitor.name': name,
    'observer.geo.name': location
  } = slo.groupings;
  const {
    locationId,
    monitorId
  } = ((_slo$meta = slo.meta) === null || _slo$meta === void 0 ? void 0 : _slo$meta.synthetics) || {};
  const indicator = slo.indicator;
  if (!_sloSchema.syntheticsAvailabilityIndicatorSchema.is(indicator)) {
    return null;
  }
  const onMonitorClick = () => monitorLocator === null || monitorLocator === void 0 ? void 0 : monitorLocator.navigate({
    configId: monitorId,
    locationId
  });
  const onLocationClick = () => regionLocator === null || regionLocator === void 0 ? void 0 : regionLocator.navigate({
    locationId: location
  });
  const showDefinitionItem = name || location;
  if (!showDefinitionItem) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: MONITOR_LABEL,
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "flexStart",
      gutterSize: "s",
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, name && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      onClick: onMonitorClick,
      iconOnClick: onMonitorClick,
      onClickAriaLabel: MONITOR_ARIA_LABEL,
      iconOnClickAriaLabel: MONITOR_ARIA_LABEL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.slo.sloDetails.overview.syntheticsMonitor.name', {
      defaultMessage: 'Name: {value}',
      values: {
        value: name
      }
    }))), location && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      onClick: onLocationClick,
      iconOnClick: onLocationClick,
      onClickAriaLabel: LOCATION_ARIA_LABEL,
      iconOnClickAriaLabel: LOCATION_ARIA_LABEL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.slo.sloDetails.overview.syntheticsMonitor.locationName', {
      defaultMessage: 'Location: {value}',
      values: {
        value: location
      }
    })))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  });
}
const MONITOR_LABEL = _i18n.i18n.translate('xpack.slo.sloDetails.overview.syntheticsMonitor', {
  defaultMessage: 'Synthetics monitor'
});
const MONITOR_ARIA_LABEL = _i18n.i18n.translate('xpack.slo.sloDetails.overview.syntheticsMonitorDetails', {
  defaultMessage: 'Synthetics monitor details'
});
const LOCATION_ARIA_LABEL = _i18n.i18n.translate('xpack.slo.sloDetails.overview.syntheticsLocationGroup', {
  defaultMessage: 'View all monitors in this location'
});