"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloGroupFilters = SloGroupFilters;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../../../common");
var _constants = require("../../../../../common/constants");
var _use_create_data_view = require("../../../../hooks/use_create_data_view");
var _use_fetch_slo_groups = require("../../../../hooks/use_fetch_slo_groups");
var _constants2 = require("../../../../pages/slo_edit/constants");
var _use_get_settings = require("../../../../pages/slo_settings/hooks/use_get_settings");
var _use_kibana = require("../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/overview/group_view/slo_group_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mapGroupsToOptions = (groups, selectedGroupBy) => {
  var _groups$map;
  return (_groups$map = groups === null || groups === void 0 ? void 0 : groups.map(group => {
    let label = group;
    if (selectedGroupBy === 'status') {
      label = group.toLowerCase();
    } else if (selectedGroupBy === 'slo.indicator.type') {
      var _text;
      label = (_text = _constants2.SLI_OPTIONS.find(option => option.value === group).text) !== null && _text !== void 0 ? _text : group;
    }
    return {
      label,
      value: group
    };
  })) !== null && _groups$map !== void 0 ? _groups$map : [];
};
function SloGroupFilters({
  selectedFilters,
  onSelected
}) {
  var _useState, _useState2, _SLI_OPTIONS$find;
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: settings
  } = (0, _use_get_settings.useGetSettings)();
  const hasRemoteEnabled = settings && (settings.useAllRemoteClusters || settings.selectedRemoteClusters.length > 0);
  const groupByOptions = [{
    text: _i18n.i18n.translate('xpack.slo.sloGroupConfiguration.groupBy.tags', {
      defaultMessage: 'Tags'
    }),
    value: 'slo.tags'
  }, {
    text: _i18n.i18n.translate('xpack.slo.sloGroupConfiguration.groupBy.status', {
      defaultMessage: 'Status'
    }),
    value: 'status'
  }, {
    text: _i18n.i18n.translate('xpack.slo.sloGroupConfiguration.groupBy.sliType', {
      defaultMessage: 'SLI type'
    }),
    value: 'slo.indicator.type'
  }, ...(hasRemoteEnabled ? [{
    text: _i18n.i18n.translate('xpack.slo.sloGroupConfiguration.groupBy.remoteCluster', {
      defaultMessage: 'Remote cluster'
    }),
    value: '_index'
  }] : [])];
  const {
    dataView
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: _constants.SUMMARY_DESTINATION_INDEX_NAME
  });
  const [selectedGroupBy, setSelectedGroupBy] = (_useState = (0, _react.useState)(selectedFilters.groupBy)) !== null && _useState !== void 0 ? _useState : 'status';
  const [filters, setFilters] = (_useState2 = (0, _react.useState)(selectedFilters.filters)) !== null && _useState2 !== void 0 ? _useState2 : [];
  const [kqlQuery, setkqlQuery] = (0, _react.useState)(selectedFilters.kqlQuery);
  const [selectedGroupByLabel, setSelectedGroupByLabel] = (0, _react.useState)('Status');
  const [groupOptions, setGroupOptions] = (0, _react.useState)([]);
  const [selectedGroupOptions, setSelectedGroupOptions] = (0, _react.useState)(mapGroupsToOptions(selectedFilters.groups, selectedGroupBy));
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const sliTypeSearch = (_SLI_OPTIONS$find = _constants2.SLI_OPTIONS.find(option => option.text.toLowerCase().includes(searchValue.toLowerCase()))) === null || _SLI_OPTIONS$find === void 0 ? void 0 : _SLI_OPTIONS$find.value;
  const query = `${searchValue}*`;
  const {
    data,
    isLoading
  } = (0, _use_fetch_slo_groups.useFetchSloGroups)({
    perPage: 100,
    groupBy: selectedGroupBy,
    kqlQuery: `slo.tags: (${query}) or status: (${query.toUpperCase()}) or slo.indicator.type: (${sliTypeSearch})`
  });
  (0, _react.useEffect)(() => {
    const isLoadedWithData = !isLoading && (data === null || data === void 0 ? void 0 : data.results) !== undefined;
    const opts = isLoadedWithData ? mapGroupsToOptions(data === null || data === void 0 ? void 0 : data.results.map(item => item.group), selectedGroupBy) : [];
    setGroupOptions(opts);
    if (selectedGroupBy === 'slo.tags') {
      setSelectedGroupByLabel(_i18n.i18n.translate('xpack.slo.sloGroupConfiguration.tagsLabel', {
        defaultMessage: 'Tags'
      }));
    } else if (selectedGroupBy === 'status') {
      setSelectedGroupByLabel(_i18n.i18n.translate('xpack.slo.sloGroupConfiguration.statusLabel', {
        defaultMessage: 'Status'
      }));
    } else if (selectedGroupBy === 'slo.indicator.type') {
      setSelectedGroupByLabel(_i18n.i18n.translate('xpack.slo.sloGroupConfiguration.sliTypeLabel', {
        defaultMessage: 'SLI type'
      }));
    } else if (selectedGroupBy === '_index') {
      setSelectedGroupByLabel(_i18n.i18n.translate('xpack.slo.sloGroupConfiguration.remoteClusterLabel', {
        defaultMessage: 'Remote cluster'
      }));
    }
  }, [isLoading, data, selectedGroupBy]);
  const onChange = opts => {
    setSelectedGroupOptions(opts);
    const selectedGroups = opts.length >= 1 ? opts.map(opt => opt.value) : [];
    onSelected('groups', selectedGroups);
  };
  const onSearchChange = (0, _react.useMemo)(() => (0, _lodash.debounce)(value => {
    setSearchValue(value);
  }, 300), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.slo.sloGroupConfiguration.groupTypeLabel', {
      defaultMessage: 'Group by'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "sloGroupOverviewConfigurationGroupBy",
    options: groupByOptions,
    value: selectedGroupBy,
    onChange: e => {
      setSelectedGroupBy(e.target.value);
      onSelected('groupBy', e.target.value);
      setSelectedGroupOptions([]);
      onSelected('groups', []);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.slo.sloGroupConfiguration.groupByLabel', {
      defaultMessage: '{ selectedGroupByLabel }',
      values: {
        selectedGroupByLabel
      }
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.sloGroupConfiguration.groupsOptional",
      defaultMessage: "Optional",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.slo.sloGroupConfiguration.sloSelector.ariaLabel', {
      defaultMessage: '{ selectedGroupByLabel }',
      values: {
        selectedGroupByLabel
      }
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloGroupConfiguration.sloSelector.placeholder', {
      defaultMessage: 'Select a {selectedGroupByLabel}',
      values: {
        selectedGroupByLabel
      }
    }),
    "data-test-subj": "sloGroupOverviewConfigurationGroup",
    options: groupOptions,
    selectedOptions: selectedGroupOptions,
    async: true,
    onChange: onChange,
    onSearchChange: onSearchChange,
    fullWidth: true,
    singleSelection: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.slo.sloGroupConfiguration.customFiltersLabel', {
      defaultMessage: 'Custom filter'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.sloGroupConfiguration.customFiltersOptional",
      defaultMessage: "Optional",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SearchBar, {
    dataTestSubj: "sloGroupOverviewConfigurationKqlBar",
    appName: _common.sloAppId,
    placeholder: PLACEHOLDER,
    indexPatterns: dataView ? [dataView] : [],
    showSubmitButton: false,
    showFilterBar: true,
    filters: filters,
    onFiltersUpdated: newFilters => {
      setFilters(newFilters);
      onSelected('filters', newFilters);
    },
    onQuerySubmit: ({
      query: value
    }) => {
      setkqlQuery(String(value === null || value === void 0 ? void 0 : value.query));
      onSelected('kqlQuery', String(value === null || value === void 0 ? void 0 : value.query));
    },
    onQueryChange: ({
      query: value
    }) => {
      setkqlQuery(String(value === null || value === void 0 ? void 0 : value.query));
      onSelected('kqlQuery', String(value === null || value === void 0 ? void 0 : value.query));
    },
    query: {
      query: String(kqlQuery),
      language: 'kuery'
    },
    showDatePicker: false,
    disableQueryLanguageSwitcher: true,
    allowSavingQueries: true,
    onClearSavedQuery: () => {},
    showQueryInput: true,
    onSavedQueryUpdated: savedQuery => {
      setFilters(savedQuery.attributes.filters);
      setkqlQuery(String(savedQuery.attributes.query.query));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 9
    }
  })));
}
const PLACEHOLDER = _i18n.i18n.translate('xpack.slo.sloGroupConfiguration.customFilterText', {
  defaultMessage: 'Custom filter'
});