"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloIncludedCount = SloIncludedCount;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_fetch_slo_list = require("../../../../hooks/use_fetch_slo_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/alerts/components/slo_included_count.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloIncludedCount({
  slos
}) {
  var _sloList$total;
  const {
    data: sloList
  } = (0, _use_fetch_slo_list.useFetchSloList)({
    kqlQuery: slos.map(slo => `slo.id:${slo.id}`).join(' or '),
    perPage: 0
  });
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloAlertsWrapper.sLOsIncludedFlexItemLabel.withInstances",
    defaultMessage: "{numOfSlos, number} {numOfSlos, plural, one {SLO} other {SLOs}}{instances} included",
    values: {
      numOfSlos: slos.length,
      instances: _i18n.i18n.translate('xpack.slo.sloAlertsWrapper.sLOsIncludedFlexItemLabel.instancesCount', {
        defaultMessage: ' ({count, number} {count, plural, one {Instance} other {Instances}})',
        values: {
          count: (_sloList$total = sloList === null || sloList === void 0 ? void 0 : sloList.total) !== null && _sloList$total !== void 0 ? _sloList$total : 0
        }
      })
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  });
}