"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildCustomKqlIndicator = exports.buildApmLatencyIndicator = exports.buildApmAvailabilityIndicator = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildApmAvailabilityIndicator = (params = {}) => {
  return {
    type: 'sli.apm.transactionErrorRate',
    params: {
      environment: 'development',
      service: 'o11y-app',
      transactionType: 'request',
      transactionName: 'GET /flaky',
      index: 'metrics-apm*',
      ...params
    }
  };
};
exports.buildApmAvailabilityIndicator = buildApmAvailabilityIndicator;
const buildApmLatencyIndicator = (params = {}) => {
  return {
    type: 'sli.apm.transactionDuration',
    params: {
      environment: 'development',
      service: 'o11y-app',
      transactionType: 'request',
      transactionName: 'GET /slow',
      threshold: 500,
      index: 'metrics-apm*',
      ...params
    }
  };
};
exports.buildApmLatencyIndicator = buildApmLatencyIndicator;
const buildCustomKqlIndicator = (params = {}) => {
  return {
    type: 'sli.kql.custom',
    params: {
      index: 'some_logs*',
      good: 'latency < 300',
      total: 'latency > 0',
      filter: 'labels.eventId: event-0',
      timestampField: '@timestamp',
      ...params
    }
  };
};
exports.buildCustomKqlIndicator = buildCustomKqlIndicator;